/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.ibso.sqltrace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import ru.cft.ibso.sqltrace.SqlTraceElement;
import ru.cft.ibso.sqltrace.SqlTraceListener;

public class SqlTracer {
    private static SqlTracer instance = new SqlTracer();
    private boolean running = false;
    private List<SqlTraceElement> elements = new ArrayList<SqlTraceElement>();
    private Collection<SqlTraceListener> listeners = new ArrayList<SqlTraceListener>();

    public static SqlTracer getInstance() {
        return instance;
    }

    private SqlTracer() {
        Iterator<SqlTraceListener> itr = ServiceLoader.load(SqlTraceListener.class).iterator();
        while (itr.hasNext()) {
            this.listeners.add(itr.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.fireOnStart();
        List<SqlTraceElement> list = this.elements;
        synchronized (list) {
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<SqlTraceElement> list = this.elements;
        synchronized (list) {
            this.running = false;
        }
        this.fireOnStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(String sql) {
        if (this.running) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            stack = Arrays.copyOfRange(stack, 3, stack.length);
            SqlTraceElement e = new SqlTraceElement(sql, stack);
            List<SqlTraceElement> list = this.elements;
            synchronized (list) {
                this.elements.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<SqlTraceElement> list = this.elements;
        synchronized (list) {
            this.elements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlTraceElement[] getTrace() {
        List<SqlTraceElement> list = this.elements;
        synchronized (list) {
            return this.elements.toArray(new SqlTraceElement[0]);
        }
    }

    private void fireOnStart() {
        for (SqlTraceListener listener : this.listeners) {
            listener.onStart();
        }
    }

    private void fireOnStop() {
        for (SqlTraceListener listener : this.listeners) {
            listener.onStop();
        }
    }
}

