/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.app.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.cft.platform.core.runtime.exception.CoreRuntimeException;
import ru.cft.platform.dbi.deployment.without.ide.postgresql.DbiDeployerArchive;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class DDLManager {
    private static String MAPPINGS_RESOURCE_NAME = "META-INF/mappings.lst";
    private static final ILogger LOG = Logger.getLogger(DDLManager.class);
    private String businessModelPath;
    private String projectPath;
    private Map<String, String> ddls = new HashMap<String, String>();
    private static DDLManager INSTANCE;
    private static Thread thread;

    public DDLManager() {
        thread = new Thread(){

            @Override
            public void run() {
                DDLManager.this.init();
            }
        };
        thread.start();
    }

    static DDLManager get() {
        if (INSTANCE == null) {
            INSTANCE = new DDLManager();
        }
        while (thread.isAlive()) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new CoreRuntimeException("Thread get temp table ddl error");
            }
        }
        return INSTANCE;
    }

    String getDdl(String tableName) {
        if (this.ddls.containsKey(tableName)) {
            return this.ddls.get(tableName);
        }
        throw new CoreRuntimeException("Create temp table ddl does not generated: " + tableName);
    }

    private void init() {
        try {
            this.businessModelPath = null;
            this.projectPath = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources(MAPPINGS_RESOURCE_NAME);
            if (!resources.hasMoreElements()) {
                LOG.warn(String.format("No one resource %s is found", MAPPINGS_RESOURCE_NAME));
            } else {
                LOG.info("Processing mapping resources:");
                while (resources.hasMoreElements() && (this.projectPath == null || this.businessModelPath == null)) {
                    URL url = resources.nextElement();
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        LOG.info("Project mappings unsupported: " + url.toExternalForm());
                        continue;
                    }
                    if (this.businessModelPath != null || !"jar".equals(protocol)) continue;
                    this.businessModelPath = this.getBusinessModelPath(url);
                    if (this.businessModelPath == null) continue;
                    LOG.info("Business model mappings: " + url.toExternalForm());
                }
            }
        }
        catch (IOException e) {
            throw new CoreRuntimeException("Unable to read Hibernate mappings urls", (Throwable)e);
        }
        this.fillDdls();
        if (this.projectPath == null && this.businessModelPath == null) {
            throw new CoreRuntimeException("Business model mappings not found");
        }
    }

    private void fillDdls() {
        if (this.businessModelPath != null) {
            DbiDeployerArchive deployer = new DbiDeployerArchive();
            deployer.setOnlyCreateTempTableDDL(true);
            deployer.setPathJarFile(this.businessModelPath);
            List errors = deployer.run();
            if (!errors.isEmpty()) {
                LOG.error("--------------------------------------------------------------");
                LOG.error("Error fill temp table DDL:");
                LOG.error((Object)errors);
                LOG.error("--------------------------------------------------------------");
            }
            this.ddls = deployer.getCreateTempTableDdls();
        }
        if (this.projectPath != null) {
            // empty if block
        }
    }

    private String getBusinessModelPath(URL url) {
        Pattern businessModelPathPattern = Pattern.compile("jar:file:(?<businessModelPath>(.)+\\/business-model-(.)+.jar)!\\/META-INF\\/mappings.lst");
        Matcher matcher = businessModelPathPattern.matcher(url.toString());
        if (matcher.find()) {
            return matcher.group("businessModelPath");
        }
        return null;
    }
}

