/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.app.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import ru.cft.platform.business.app.runtime.DDLManager;
import ru.cft.platform.business.runtime.dao.DataSourceService;
import ru.cft.platform.core.container.OperationContext;
import ru.cft.platform.core.container.util.QueryHelper;
import ru.cft.platform.core.dao.DAO;
import ru.cft.platform.core.packages.rtl;
import ru.cft.platform.core.runtime.exception.CoreRuntimeException;
import ru.cft.platform.core.runtime.type.Varchar2;
import ru.cft.platform.hibernate.Query;
import ru.cft.platform.hibernate.SQLDialect;
import ru.cft.platform.hibernate.ScrollableResults;

public class CreateTempTableService {
    private static CreateTempTableService INSTANCE = new CreateTempTableService();

    static CreateTempTableService get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTempTable(Varchar2 P_CLASS_ID) {
        try {
            if (!this.isPg()) {
                return;
            }
            String tabName = this.getTableName(P_CLASS_ID.getValue());
            Connection conn = OperationContext.get().getCurrentConnection();
            try (PreparedStatement st = conn.prepareStatement("select * from information_schema.tables where table_name = '" + tabName + "' and table_type='BASE TABLE'");){
                ResultSet rs = st.executeQuery();
                if (rs != null && rs.next()) {
                    throw new CoreRuntimeException("Table " + tabName + " is not temp table");
                }
            }
            String sql = "drop table if exists \"" + tabName + "\";\n\n";
            sql = sql + DDLManager.get().getDdl(tabName);
            st = conn.prepareStatement(sql);
            try {
                st.execute();
            }
            finally {
                st.close();
            }
        }
        catch (Exception e) {
            throw new CoreRuntimeException((Throwable)e);
        }
    }

    private boolean isPg() {
        return OperationContext.get().getCurrentSession().getSQLDialect().getDatabase() == SQLDialect.Database.POSTGRESQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTableName(String classId) {
        String tabName = "";
        ScrollableResults selectTableName = null;
        try {
            selectTableName = QueryHelper.scroll((Query)QueryHelper.createExtendedSQLQuery((String)"select  a1.temp_type, b1.table_name\nfrom CLASS_TABLES b1, CLASSES a1\nwhere a1.ID = :plp$1$1 and a1.ID = b1.CLASS_ID and a1.temp_type in ('D', 'P')", (DAO)DataSourceService.getClassDAO((String)"METACLASS")).setString("plp$1$1", classId).setFetchSize(2));
            if (!selectTableName.next()) {
                throw new rtl.no_data_found();
            }
            tabName = (String)selectTableName.get()[1];
            if (selectTableName.next()) {
                throw new rtl.too_many_rows();
            }
        }
        finally {
            if (selectTableName != null) {
                selectTableName.close();
                selectTableName = null;
            }
        }
        if (tabName == null) {
            throw new CoreRuntimeException("Table " + tabName + " not found");
        }
        return tabName;
    }
}

