/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.app.runtime;

import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import ru.cft.platform.business.runtime.annotation.CompilerInfo;
import ru.cft.platform.business.runtime.annotation.Redirect;
import ru.cft.platform.business.runtime.dao.BusinessDAO;
import ru.cft.platform.business.runtime.dao.DataSourceService;
import ru.cft.platform.business.runtime.method.BusinessPackage;
import ru.cft.platform.core.container.util.QueryHelper;
import ru.cft.platform.core.packages.rtl;
import ru.cft.platform.core.runtime.type.Clonable;
import ru.cft.platform.core.runtime.type.Varchar2;

@CompilerInfo(compiler="plp2java", version=1)
public class ENVIRONMENT
extends BusinessPackage {
    private static final long serialVersionUID = 1L;
    public final Varchar2 DB_ORACLE = new Varchar2(128);
    public final Varchar2 DB_POSTGRESQL = new Varchar2(128);
    public final Varchar2 DB_IGNITE = new Varchar2(128);
    public final Varchar2 DB_UNKNOWN = new Varchar2(128);
    public final HashMap<String, String> CHARSET_NAMES_PGS_IANA = new HashMap();

    @Redirect(proc="CLASSSTORAGE")
    public CLASS_STORAGE_TYPE CLASSSTORAGE(Varchar2 P_CLASS_ID) {
        List charsetList;
        List dbNameList;
        CLASS_STORAGE_TYPE STORAGE = new CLASS_STORAGE_TYPE();
        BusinessDAO dao = DataSourceService.getClassDAO((String)P_CLASS_ID.toString());
        String productName = "";
        try {
            productName = dao.getCurrentConnection().getMetaData().getDatabaseProductName().toUpperCase();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (productName.contains("POSTGRE")) {
            STORAGE.DBTYPE.assign(this.DB_POSTGRESQL);
        } else if (productName.contains("IGNITE")) {
            STORAGE.DBTYPE.assign(this.DB_IGNITE);
        } else if (productName.contains("ORACLE")) {
            STORAGE.DBTYPE.assign(this.DB_ORACLE);
        } else {
            STORAGE.DBTYPE.assign(this.DB_UNKNOWN);
        }
        if (STORAGE.DBTYPE.equals((Object)this.DB_ORACLE)) {
            dbNameList = QueryHelper.createExtendedSQLQuery((String)"select sys_context('USERENV', 'DB_NAME') from dual").list();
        } else if (STORAGE.DBTYPE.equals((Object)this.DB_POSTGRESQL)) {
            dbNameList = QueryHelper.createExtendedSQLQuery((String)"select current_database()").list();
        } else {
            return STORAGE;
        }
        if (ENVIRONMENT.isValid(dbNameList)) {
            String dbName = (String)dbNameList.get(0);
            STORAGE.DBNAME.assign(dbName);
        }
        if (STORAGE.DBTYPE.equals((Object)this.DB_ORACLE)) {
            charsetList = QueryHelper.createExtendedSQLQuery((String)"select UTL_I18N.MAP_CHARSET(VALUE) from NLS_DATABASE_PARAMETERS where parameter = 'NLS_CHARACTERSET'").list();
        } else if (STORAGE.DBTYPE.equals((Object)this.DB_POSTGRESQL)) {
            charsetList = QueryHelper.createExtendedSQLQuery((String)"select character_set_name from information_schema.character_sets").list();
        } else {
            return STORAGE;
        }
        if (ENVIRONMENT.isValid(charsetList)) {
            String charsetNameDB = (String)charsetList.get(0);
            if (STORAGE.DBTYPE.equals((Object)this.DB_ORACLE)) {
                STORAGE.DEFCHARSET.assign(charsetNameDB);
            } else if (this.CHARSET_NAMES_PGS_IANA.containsKey(charsetNameDB)) {
                STORAGE.DEFCHARSET.assign(this.CHARSET_NAMES_PGS_IANA.get(charsetNameDB));
            } else {
                STORAGE.DEFCHARSET.assign(charsetNameDB);
            }
        }
        return STORAGE;
    }

    @Redirect(proc="APPSERVERINFO")
    public APPSERVER_INFO_TYPE APPSERVERINFO() {
        APPSERVER_INFO_TYPE INFO = new APPSERVER_INFO_TYPE();
        INFO.DEFCHARSET.assign(Charset.defaultCharset().name());
        return INFO;
    }

    public void initialize() {
        this.DB_ORACLE.assign(new Varchar2("ORA"));
        this.DB_POSTGRESQL.assign(new Varchar2("PG"));
        this.DB_IGNITE.assign(new Varchar2("IG"));
        this.DB_UNKNOWN.assign(new Varchar2("UNKNOWN_DB"));
        this.CHARSET_NAMES_PGS_IANA.put("WIN866", "IBM866");
        this.CHARSET_NAMES_PGS_IANA.put("ISO_8859_5", "ISO-8859-5");
        this.CHARSET_NAMES_PGS_IANA.put("WIN1251", "WINDOWS-1251");
        this.CHARSET_NAMES_PGS_IANA.put("KOI8R", "KOI8-R");
        this.CHARSET_NAMES_PGS_IANA.put("UTF8", "UTF-8");
    }

    public String getClassId() {
        return "RUNTIME";
    }

    public String getShortName() {
        return "ENVIRONMENT";
    }

    private static boolean isValid(List<?> resultList) {
        if (resultList.isEmpty()) {
            throw new rtl.no_data_found();
        }
        if (resultList.size() > 1) {
            throw new rtl.too_many_rows();
        }
        return true;
    }

    public static class APPSERVER_INFO_TYPE
    implements Clonable<APPSERVER_INFO_TYPE> {
        public final Varchar2 DEFCHARSET = new Varchar2(128);

        public void assign(APPSERVER_INFO_TYPE other) {
            APPSERVER_INFO_TYPE dummy = other == null ? new APPSERVER_INFO_TYPE() : other;
            this.DEFCHARSET.assign(dummy.DEFCHARSET);
        }

        public APPSERVER_INFO_TYPE() {
        }

        public APPSERVER_INFO_TYPE(APPSERVER_INFO_TYPE other) {
            this.assign(other);
        }

        public APPSERVER_INFO_TYPE copy() {
            return new APPSERVER_INFO_TYPE(this);
        }
    }

    public static class CLASS_STORAGE_TYPE
    implements Clonable<CLASS_STORAGE_TYPE> {
        public final Varchar2 DBTYPE = new Varchar2(128);
        public final Varchar2 DBNAME = new Varchar2(128);
        public final Varchar2 DEFCHARSET = new Varchar2(128);

        public void assign(CLASS_STORAGE_TYPE other) {
            CLASS_STORAGE_TYPE dummy = other == null ? new CLASS_STORAGE_TYPE() : other;
            this.DBTYPE.assign(dummy.DBTYPE);
            this.DBNAME.assign(dummy.DBNAME);
            this.DEFCHARSET.assign(dummy.DEFCHARSET);
        }

        public CLASS_STORAGE_TYPE() {
        }

        public CLASS_STORAGE_TYPE(CLASS_STORAGE_TYPE other) {
            this.assign(other);
        }

        public CLASS_STORAGE_TYPE copy() {
            return new CLASS_STORAGE_TYPE(this);
        }
    }
}

