/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.runtime.orsa;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class OrsaUtils {
    private static final String UPDATE_QUERY = "UPDATE ORSA_JOBS_OUT SET BODY = ? WHERE JOB = ? AND POS = ? AND OUT_TYPE = ? AND (CLIENT_PATH IS NULL OR CLIENT_PATH = ?)";
    private static final String INSERT_QUERY = "INSERT INTO ORSA_JOBS_OUT (BODY, JOB, POS, OUT_TYPE, CLIENT_PATH) VALUES (?, ?, ?, ?, ?)";
    private final Connection connection;

    public OrsaUtils(Connection connection) {
        this.connection = connection;
    }

    public void saveBlobAsReportBody(Blob blob, BigDecimal job, BigDecimal pos, String outType) throws SQLException, IOException {
        this.saveBlobAsReportBody(blob, job, pos, outType, "");
    }

    public void saveBlobAsReportBody(Blob blob, BigDecimal job, BigDecimal pos, String outType, String clientPath) throws SQLException, IOException {
        long blobSize = blob.length();
        if (blobSize > Integer.MAX_VALUE) {
            throw new RuntimeException("Blob is too large");
        }
        try {
            BlobQueryParameters parameters = new BlobQueryParameters(blob, job, pos, outType, clientPath);
            if (OrsaUtils.updateBlobAsReportBody(parameters, this.connection) == 0) {
                OrsaUtils.insertBlobAsReportBody(parameters, this.connection);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error in saveBlobAsReportBody");
        }
    }

    private static int updateBlobAsReportBody(BlobQueryParameters parameters, Connection connection) throws SQLException, IOException {
        return OrsaUtils.executeBlobQuery(parameters, connection, UPDATE_QUERY);
    }

    private static int insertBlobAsReportBody(BlobQueryParameters parameters, Connection connection) throws SQLException, IOException {
        return OrsaUtils.executeBlobQuery(parameters, connection, INSERT_QUERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeBlobQuery(BlobQueryParameters parameters, Connection connection, String query) throws SQLException, IOException {
        try (InputStream blobStream = null;){
            int n;
            block8: {
                Blob blob = parameters.getBlob();
                blobStream = new BufferedInputStream(blob.getBinaryStream());
                PreparedStatement statement = null;
                try {
                    statement = connection.prepareStatement(query);
                    statement.setBinaryStream(1, blobStream, (int)blob.length());
                    statement.setBigDecimal(2, parameters.getJob());
                    statement.setBigDecimal(3, parameters.getPos());
                    statement.setString(4, parameters.getOutType());
                    statement.setString(5, parameters.getClientPath());
                    statement.execute();
                    n = statement.getUpdateCount();
                    if (statement == null) break block8;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        statement.close();
                    }
                    throw throwable;
                }
                statement.close();
            }
            return n;
        }
    }

    private static class BlobQueryParameters {
        private final Blob blob;
        private final BigDecimal job;
        private final BigDecimal pos;
        private final String outType;
        private final String clientPath;

        public BlobQueryParameters(Blob blob, BigDecimal job, BigDecimal pos, String outType, String clientPath) {
            this.blob = blob;
            this.job = job;
            this.pos = pos;
            this.outType = outType;
            this.clientPath = clientPath;
        }

        public Blob getBlob() {
            return this.blob;
        }

        public BigDecimal getJob() {
            return this.job;
        }

        public BigDecimal getPos() {
            return this.pos;
        }

        public String getOutType() {
            return this.outType;
        }

        public String getClientPath() {
            return this.clientPath;
        }
    }
}

