/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.app.runtime;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import javax.sql.rowset.serial.SerialBlob;
import ru.cft.platform.business.runtime.Context;
import ru.cft.platform.business.runtime.annotation.CompilerInfo;
import ru.cft.platform.business.runtime.core.message;
import ru.cft.platform.business.runtime.dao.BusinessDAO;
import ru.cft.platform.business.runtime.method.BusinessPackage;
import ru.cft.platform.business.runtime.method.IdentifierSelectingPackage;
import ru.cft.platform.business.runtime.orsa.OrsaUtils;
import ru.cft.platform.core.container.dao.ReportDataAccess;
import ru.cft.platform.core.container.orm.metamodel.IOrsaJob;
import ru.cft.platform.core.runtime.type.Blob;
import ru.cft.platform.core.runtime.type.Number;
import ru.cft.platform.core.runtime.type.Varchar2;
import ru.cft.platform.hibernate.LockMode;

@CompilerInfo(compiler="plp2java", version=1)
public class ORSAUTILS_LIB
extends BusinessPackage
implements IdentifierSelectingPackage {
    private static final long serialVersionUID = 1L;

    public void SAVEBLOBASREPORTBODY(Blob p_blob, Number p_job, Number p_pos, Varchar2 p_out_type) {
        Connection connection = BusinessDAO.get().getCurrentConnection();
        OrsaUtils orsaUtils = new OrsaUtils(connection);
        try {
            SerialBlob blob = new SerialBlob(p_blob.getValue());
            orsaUtils.saveBlobAsReportBody(blob, p_job.getValue(), p_pos.getValue(), p_out_type.getValue());
        }
        catch (IOException | SQLException e) {
            ((message)Context.getPackage(message.class)).error("EXEC", "ERR_REPORT_JOB", "Save blob as report body error. Job:" + p_job.getIntValue() + ", pos:" + p_pos.getIntValue());
            e.printStackTrace();
        }
    }

    public void MARKEXECUTED(Number p_state, Number p_job, Number p_pos, ru.cft.platform.core.runtime.type.Date p_date_run, ru.cft.platform.core.runtime.type.Date p_date_schedule, ru.cft.platform.core.runtime.type.Date p_date_executed) {
        IOrsaJob orsaJob = ReportDataAccess.getInstance().getOrsaJob(p_job.getIntValue(), p_pos.getIntValue(), LockMode.UPGRADE_NOWAIT);
        if (orsaJob == null) {
            ((message)Context.getPackage(message.class)).error("EXEC", "ERR_REPORT_JOB", "Mark executed error, OrsaJob not found. job:" + p_job.getIntValue() + ", pos:" + p_pos.getIntValue());
            return;
        }
        orsaJob.setStateCode(Integer.valueOf(p_state.getIntValue()));
        orsaJob.setDateRun((Date)p_date_run.getValue());
        orsaJob.setDateSchedule((Date)p_date_schedule.getValue());
        orsaJob.setDateExecuted((Date)p_date_executed.getValue());
        ReportDataAccess.getInstance().update((Object)orsaJob);
    }

    public void initialize() {
    }

    public String getClassId() {
        return "RUNTIME";
    }

    public String getShortName() {
        return "ORSAUTILS_LIB";
    }

    public void initializeConditionSelectedFields() {
    }
}

