/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ntlm;

import java.util.Map;
import org.ntlmv2.liferay.NtlmManager;
import ru.cft.platform.crpwd.crypt.password.CryptPassword;
import ru.cft.platform.jaas.ntlm.NTLMAuthenticationInformation;
import ru.cft.platform.jaas.ntlm.NTLMException;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class NTLMServer {
    private static final String DOMAIN_CONTROLLER_DOMAIN_SHORT_NAME = "domain-controller-domain-short-name";
    private static final String DOMAIN_CONTROLLER_DOMAIN_FULL_NAME = "domain-controller-domain-full-name";
    private static final String DOMAIN_CONTROLLER_FULL_HOST_NAME = "domain-controller-full-host-name";
    private static final String DOMAIN_CONTROLLER_ADDRESS = "domain-controller-address";
    private static final String SERVICE_ACCOUNT_NAME = "service-account-name";
    private static final String SERVICE_ACCOUNT_PASSWORD = "service-account-password";
    private static final char OWNER_PSW_PREFIX = '=';
    private static final String INITIALIZED_TEXT = "\u041f\u0440\u043e\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d %s:\n\t\u041a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u0438\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u0434\u043e\u043c\u0435\u043d\u0430: %s\n\t\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f \u0445\u043e\u0441\u0442\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u0434\u043e\u043c\u0435\u043d\u0430: %s\n\t\u0410\u0434\u0440\u0435\u0441 \u0445\u043e\u0441\u0442\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u0434\u043e\u043c\u0435\u043d\u0430: %s\n\t\u0418\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430: %s";
    private static final String DOMAIN_CONTROLLER_DOMAIN_SHORT_NAME_NOT_SET_ERROR_TEXT = "\u041a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u0438\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u0434\u043e\u043c\u0435\u043d\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e";
    private static final String DOMAIN_CONTROLLER_FULL_HOST_NAME_NOT_SET_ERROR_TEXT = "\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f \u0445\u043e\u0441\u0442\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430 \u0434\u043e\u043c\u0435\u043d\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e";
    private static final String SERVICE_ACCOUNT_NAME_NOT_SET_ERROR_TEXT = "\u0418\u043c\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e";
    private static final String SERVICE_ACCOUNT_PASSWORD_NOT_SET_ERROR_TEXT = "\u041f\u0430\u0440\u043e\u043b\u044c \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
    private static final ILogger LOGGER = Logger.getLogger(NTLMServer.class);
    private final String domainControllerDomainShortName;
    private final String domainControllerFullHostName;
    private final String domainControllerAddress;
    private final String serviceAccountFullName;
    private final String serviceAccountPassword;
    private final String domainControllerDomainFullName;
    private NtlmManager ntlmManager;
    private String name;

    public NTLMServer(String name, Map<String, String> properties) throws NTLMException {
        this.name = name;
        this.domainControllerDomainShortName = properties.get(DOMAIN_CONTROLLER_DOMAIN_SHORT_NAME);
        this.domainControllerDomainFullName = properties.get(DOMAIN_CONTROLLER_DOMAIN_FULL_NAME);
        this.domainControllerFullHostName = properties.get(DOMAIN_CONTROLLER_FULL_HOST_NAME);
        String domainControllerAddressLocal = properties.get(DOMAIN_CONTROLLER_ADDRESS);
        String serviceAccountName = properties.get(SERVICE_ACCOUNT_NAME);
        this.serviceAccountPassword = NTLMServer.decrypt(properties.get(SERVICE_ACCOUNT_PASSWORD));
        this.domainControllerAddress = domainControllerAddressLocal != null && !domainControllerAddressLocal.isEmpty() ? domainControllerAddressLocal : this.domainControllerFullHostName;
        this.serviceAccountFullName = this.domainControllerDomainShortName != null && !this.domainControllerDomainShortName.isEmpty() && serviceAccountName != null && !serviceAccountName.isEmpty() ? serviceAccountName + "$@" + this.domainControllerDomainShortName : null;
        this.ntlmManager = this.createManager();
        LOGGER.debug(String.format(INITIALIZED_TEXT, this.name, this.domainControllerDomainShortName, this.domainControllerFullHostName, this.domainControllerAddress, this.serviceAccountFullName));
    }

    private static String decrypt(String pswBase64) {
        if (pswBase64 == null || pswBase64.isEmpty()) {
            return pswBase64;
        }
        if (pswBase64.charAt(0) != '=') {
            return pswBase64;
        }
        return NTLMServer.decryptIt(pswBase64.substring(1));
    }

    private static String decryptIt(String pswBase64) {
        try {
            return new CryptPassword().decryptBase64(pswBase64);
        }
        catch (Exception e) {
            LOGGER.error("Error decrypt password!", (Throwable)e);
            return pswBase64;
        }
    }

    private NtlmManager createManager() throws NTLMException {
        this.checkLoginRequires();
        return new NtlmManager(this.domainControllerDomainShortName, this.domainControllerAddress, this.domainControllerFullHostName, this.serviceAccountFullName, this.serviceAccountPassword);
    }

    private void checkLoginRequires() throws NTLMException {
        if (this.domainControllerDomainShortName == null || this.domainControllerDomainShortName.isEmpty()) {
            throw new NTLMException(DOMAIN_CONTROLLER_DOMAIN_SHORT_NAME_NOT_SET_ERROR_TEXT);
        }
        if (this.domainControllerFullHostName == null || this.domainControllerFullHostName.isEmpty()) {
            throw new NTLMException(DOMAIN_CONTROLLER_FULL_HOST_NAME_NOT_SET_ERROR_TEXT);
        }
        if (this.serviceAccountFullName == null || this.serviceAccountFullName.isEmpty()) {
            throw new NTLMException(SERVICE_ACCOUNT_NAME_NOT_SET_ERROR_TEXT);
        }
        if (this.serviceAccountPassword == null || this.serviceAccountPassword.isEmpty()) {
            throw new NTLMException(SERVICE_ACCOUNT_PASSWORD_NOT_SET_ERROR_TEXT);
        }
    }

    public NTLMAuthenticationInformation checkDomain(NTLMAuthenticationInformation authenticationInformation) throws NTLMException {
        LOGGER.debug(this.toString() + ": check domain");
        return authenticationInformation.checkDomain(this.domainControllerDomainShortName);
    }

    public String getDomainControllerDomainFullName() {
        return this.domainControllerDomainFullName;
    }

    public NtlmManager getManager() {
        return this.ntlmManager;
    }

    public String toString() {
        return NTLMServer.class.getSimpleName() + "{" + this.name + "}";
    }
}

