/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ntlm;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import jcifs.ntlmssp.Type3Message;
import org.ntlmv2.liferay.NtlmLogonException;
import ru.cft.platform.jaas.BytesMessageCallback;
import ru.cft.platform.jaas.BytesMessageException;
import ru.cft.platform.jaas.ntlm.BaseNTLMLoginModule;
import ru.cft.platform.jaas.ntlm.NTLMException;
import ru.cft.platform.jaas.ntlm.NTLMServer;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class NTLMProtocolLoginModule
extends BaseNTLMLoginModule<byte[]> {
    private static final ILogger LOGGER = Logger.getLogger(NTLMProtocolLoginModule.class);

    public NTLMProtocolLoginModule() {
        LOGGER.trace("create");
    }

    @Override
    protected byte[] getAuthenticationInformation(CallbackHandler callbackHandler) throws NTLMException, IOException, UnsupportedCallbackException {
        LOGGER.trace("getAuthenticationInformation");
        BytesMessageCallback ntlmProtocolCallback = new BytesMessageCallback();
        Callback[] callbacks = new Callback[]{ntlmProtocolCallback};
        callbackHandler.handle(callbacks);
        return ntlmProtocolCallback.getType1Or3Message();
    }

    @Override
    protected byte[] checkAuthenticationInformation(NTLMServer server, byte[] presentedAuthenticationInformation) throws NTLMException {
        return presentedAuthenticationInformation;
    }

    @Override
    protected void negotiate(NTLMServer server, byte[] authenticationInformation) throws IOException, NoSuchAlgorithmException, NtlmLogonException, BytesMessageException {
        LOGGER.trace("negotiate " + server.toString());
        try {
            byte[] type2Message = server.getManager().negotiate(authenticationInformation, this.challenge);
            LOGGER.debug("send type2message back to client");
            throw new BytesMessageException(type2Message);
        }
        catch (IOException e) {
            if (!"Not a Type 1 message.".equals(e.getMessage())) {
                LOGGER.debug("Exception while negotiate:", (Throwable)e);
                throw e;
            }
            LOGGER.debug("Continue negotiation with type3message");
            Type3Message type3Message = new Type3Message(authenticationInformation);
            this.authenticate(server, type3Message);
            return;
        }
    }
}

