/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ntlm;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.ntlmv2.liferay.NtlmLogonException;
import ru.cft.platform.jaas.BytesMessageException;
import ru.cft.platform.jaas.ntlm.BaseNTLMLoginModule;
import ru.cft.platform.jaas.ntlm.NTLMAuthenticationInformation;
import ru.cft.platform.jaas.ntlm.NTLMException;
import ru.cft.platform.jaas.ntlm.NTLMServer;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class NTLMLoginModule
extends BaseNTLMLoginModule<NTLMAuthenticationInformation> {
    private static final ILogger LOGGER = Logger.getLogger(NTLMLoginModule.class);

    public NTLMLoginModule() {
        LOGGER.trace("create");
    }

    @Override
    protected NTLMAuthenticationInformation getAuthenticationInformation(CallbackHandler callbackHandler) throws NTLMException, IOException, UnsupportedCallbackException {
        LOGGER.trace("getAuthenticationInformation");
        NameCallback nameCallback = new NameCallback("username");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        callbackHandler.handle(callbacks);
        return new NTLMAuthenticationInformation(nameCallback.getName(), passwordCallback.getPassword());
    }

    private static int composeNTLMFlags() {
        return 557571;
    }

    @Override
    protected NTLMAuthenticationInformation checkAuthenticationInformation(NTLMServer server, NTLMAuthenticationInformation presentedAuthenticationInformation) throws NTLMException {
        return server.checkDomain(presentedAuthenticationInformation);
    }

    @Override
    protected void negotiate(NTLMServer server, NTLMAuthenticationInformation authenticationInformation) throws IOException, NoSuchAlgorithmException, NtlmLogonException, BytesMessageException {
        LOGGER.trace("negotiate " + server.toString());
        Type1Message type1Message = new Type1Message(NTLMLoginModule.composeNTLMFlags(), null, new String());
        byte[] type2Message = server.getManager().negotiate(type1Message.toByteArray(), this.challenge);
        String domain = authenticationInformation.getDomain();
        String user = authenticationInformation.getUser();
        Type3Message type3Message = new Type3Message(new Type2Message(type2Message), new String(authenticationInformation.getPassword()), domain, user, new String(), NTLMLoginModule.composeNTLMFlags());
        this.authenticate(server, type3Message);
    }
}

