/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ntlm;

import ru.cft.platform.jaas.ntlm.NTLMException;

public class NTLMAuthenticationInformation {
    private static final String USER_NOT_SET_ERROR_TEXT = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
    private static final String PASSWORD_NOT_SET_ERROR_TEXT = "\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
    private static final String DOMAIN_NOT_SET_ERROR_TEXT = "\u0414\u043e\u043c\u0435\u043d \u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
    private final String domain;
    private final String user;
    private final char[] password;

    public NTLMAuthenticationInformation(String domainUser, char[] password) throws NTLMException {
        if (domainUser == null || domainUser.isEmpty()) {
            throw new NTLMException(USER_NOT_SET_ERROR_TEXT);
        }
        if (password == null || password.length == 0) {
            throw new NTLMException(PASSWORD_NOT_SET_ERROR_TEXT);
        }
        int position = domainUser.indexOf(92);
        if (position < 0) {
            this.domain = null;
            this.user = domainUser;
        } else {
            this.domain = domainUser.substring(0, position);
            this.user = domainUser.substring(position + 1);
        }
        if (this.user == null || this.user.isEmpty()) {
            throw new NTLMException(USER_NOT_SET_ERROR_TEXT);
        }
        this.password = password;
    }

    private NTLMAuthenticationInformation(String domain, String user, char[] password) {
        this.domain = domain;
        this.user = user;
        this.password = password;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUser() {
        return this.user;
    }

    public char[] getPassword() {
        return this.password;
    }

    public NTLMAuthenticationInformation checkDomain(String defaultDomain) throws NTLMException {
        if (this.domain != null && !this.domain.isEmpty()) {
            return this;
        }
        if (defaultDomain == null || defaultDomain.isEmpty()) {
            throw new NTLMException(DOMAIN_NOT_SET_ERROR_TEXT);
        }
        return new NTLMAuthenticationInformation(defaultDomain, this.user, this.password);
    }
}

