/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ntlm;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import jcifs.ntlmssp.Type3Message;
import org.ntlmv2.liferay.NtlmLogonException;
import ru.cft.platform.jaas.BytesMessageException;
import ru.cft.platform.jaas.ntlm.MainFirstIgnoreCaseComparator;
import ru.cft.platform.jaas.ntlm.NTLMException;
import ru.cft.platform.jaas.ntlm.NTLMPrincipal;
import ru.cft.platform.jaas.ntlm.NTLMServer;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public abstract class BaseNTLMLoginModule<T>
implements LoginModule {
    private static final ILogger LOGGER = Logger.getLogger(BaseNTLMLoginModule.class);
    private static final String COMMITTED_TEXT = "\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d";
    private static final String ABORTED_TEXT = "\u041f\u0440\u0435\u0440\u0432\u0430\u043d";
    private static final String LOGGED_OUT_TEXT = "\u0412\u044b\u0448\u0435\u043b";
    private static final String COMMIT_ERROR_TEXT = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u0438\u043a\u0441\u0430\u0446\u0438\u0438";
    private static final String ABORT_ERROR_TEXT = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u044f";
    private static final String LOGOUT_ERROR_TEXT = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u0445\u043e\u0434\u0430";
    private static final String CALLBACK_HANDLER_NOT_SET_ERROR_TEXT = "CallbackHandler \u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
    private static final String OS_DOMAIN_TEXT = "OS_DOMAIN";
    private static final String OS_USER_TEXT = "OS_USER";
    private static final String SUBJECT_NOT_SET_ERROR_TEXT = "\u0421\u0443\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d";
    private static final String SUBJECT_READ_ONLY_ERROR_TEXT = "\u0421\u0443\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u043e\u0434\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d";
    protected static final String USER_CASE_SENSITIVE = "user-case-sensitive";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private final Map<String, NTLMServer> servers;
    private boolean loggedIn;
    private boolean committed;
    private NTLMPrincipal principal;
    private Properties properties;
    private boolean userCaseSensitive = false;
    protected byte[] challenge = new byte[8];

    protected BaseNTLMLoginModule() {
        this.servers = new TreeMap<String, NTLMServer>(MainFirstIgnoreCaseComparator.getInstance());
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        LOGGER.trace("initialize");
        this.clear();
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        options = new HashMap(options);
        if (options.containsKey(USER_CASE_SENSITIVE)) {
            this.userCaseSensitive = Boolean.parseBoolean(options.get(USER_CASE_SENSITIVE).toString());
            options.remove(USER_CASE_SENSITIVE);
        }
        this.fillServers(options);
        new SecureRandom().nextBytes(this.challenge);
    }

    protected void clear() {
        this.loggedIn = false;
        this.committed = false;
        this.principal = null;
        this.properties = null;
    }

    private void fillServers(Map<String, ?> options) {
        this.servers.clear();
        HashMap<String, HashMap<String, String>> serversProperties = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, ?> entry : options.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.isEmpty()) continue;
            String server = null;
            String propertyName = null;
            int position = key.indexOf(46);
            if (position > 0) {
                server = key.substring(0, position);
                propertyName = key.substring(position + 1);
            } else {
                server = "main";
                propertyName = key;
            }
            HashMap<String, String> serverProperties = (HashMap<String, String>)serversProperties.get(server);
            if (serverProperties == null) {
                serverProperties = new HashMap<String, String>();
                serversProperties.put(server, serverProperties);
            }
            serverProperties.put(propertyName, (String)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : serversProperties.entrySet()) {
            String server = entry.getKey();
            try {
                this.servers.put(server, new NTLMServer(server, (Map)entry.getValue()));
            }
            catch (NTLMException e) {
                LOGGER.warn("Bad configuration for '" + server + "' - " + e.getMessage());
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        LOGGER.trace("login");
        if (this.loggedIn) {
            return false;
        }
        T presentedAuthenticationInformation = null;
        try {
            presentedAuthenticationInformation = this.getAuthenticationInformation();
        }
        catch (Exception e) {
            this.clear();
            throw this.logAndRecreateError("Get authentication information failed", e);
        }
        Exception lastException = null;
        for (NTLMServer server : this.servers.values()) {
            try {
                LOGGER.debug("Try negotiate with " + server.toString());
                T authenticationInformation = this.checkAuthenticationInformation(server, presentedAuthenticationInformation);
                this.negotiate(server, authenticationInformation);
                LOGGER.debug("Negotiation with " + server.toString() + " successed");
                return true;
            }
            catch (LoginException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.debug("Negotiation with " + server + " failed with error: " + e.getMessage(), (Throwable)e);
                lastException = e;
            }
        }
        this.clear();
        throw this.logAndRecreateError("Login error", lastException);
    }

    private T getAuthenticationInformation() throws NTLMException, IOException, UnsupportedCallbackException {
        if (this.callbackHandler == null) {
            throw new NTLMException(CALLBACK_HANDLER_NOT_SET_ERROR_TEXT);
        }
        return this.getAuthenticationInformation(this.callbackHandler);
    }

    protected abstract T getAuthenticationInformation(CallbackHandler var1) throws NTLMException, IOException, UnsupportedCallbackException;

    protected void authenticate(NTLMServer server, Type3Message type3Message) throws IOException, NoSuchAlgorithmException, NtlmLogonException {
        LOGGER.trace("authenticate " + server.toString());
        String user = type3Message.getUser();
        String domain = server.getDomainControllerDomainFullName() != null ? server.getDomainControllerDomainFullName() : type3Message.getDomain();
        server.getManager().authenticate(type3Message.toByteArray(), this.challenge);
        this.principal = new NTLMPrincipal(domain, user);
        this.properties = new Properties();
        this.properties.put(OS_DOMAIN_TEXT, domain);
        this.properties.put(OS_USER_TEXT, user);
        this.properties.put("CASE_SENSITIVE", (Object)this.userCaseSensitive);
        this.loggedIn = true;
        LOGGER.debug(String.format("Logged in: %s\\%s", domain, user));
    }

    private NTLMException logAndRecreateError(String errorKind, Exception e) {
        LOGGER.error(errorKind, (Throwable)e);
        String message = e.getMessage();
        return new NTLMException(errorKind + (message == null || message.isEmpty() ? "" : ": " + message), e);
    }

    protected abstract T checkAuthenticationInformation(NTLMServer var1, T var2) throws NTLMException;

    protected abstract void negotiate(NTLMServer var1, T var2) throws IOException, NoSuchAlgorithmException, NtlmLogonException, BytesMessageException;

    @Override
    public boolean commit() throws LoginException {
        try {
            if (!this.loggedIn || this.committed) {
                return false;
            }
            this.checkSubject();
            this.subject.getPrincipals().add(this.principal);
            this.subject.getPrivateCredentials().add(this.properties);
            this.committed = true;
            LOGGER.debug(COMMITTED_TEXT);
            return true;
        }
        catch (Exception e) {
            throw this.logAndRecreateError(COMMIT_ERROR_TEXT, e);
        }
    }

    private void checkSubject() throws NTLMException {
        if (this.subject == null) {
            throw new NTLMException(SUBJECT_NOT_SET_ERROR_TEXT);
        }
        if (this.subject.isReadOnly()) {
            throw new NTLMException(SUBJECT_READ_ONLY_ERROR_TEXT);
        }
    }

    @Override
    public boolean abort() throws LoginException {
        try {
            if (!this.loggedIn) {
                return false;
            }
            if (!this.committed) {
                this.clear();
            } else {
                boolean result = this.logout();
                if (!result) {
                    return result;
                }
            }
            LOGGER.debug(ABORTED_TEXT);
            return true;
        }
        catch (Exception e) {
            throw this.logAndRecreateError(ABORT_ERROR_TEXT, e);
        }
    }

    @Override
    public boolean logout() throws LoginException {
        try {
            if (!this.loggedIn || !this.committed) {
                return false;
            }
            this.checkSubject();
            this.subject.getPrincipals().remove(this.principal);
            this.subject.getPrivateCredentials().remove(this.properties);
            this.clear();
            LOGGER.debug(LOGGED_OUT_TEXT);
            return true;
        }
        catch (Exception e) {
            throw this.logAndRecreateError(LOGOUT_ERROR_TEXT, e);
        }
    }
}

