/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.logging.internal;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Predicate;

public class ServiceUtils {
    public static <T> T lookup(Class<T> service, Predicate<T> filter, boolean notNull) throws ServiceConfigurationError {
        T result = null;
        if (service == null) {
            throw new IllegalArgumentException("Service class is null");
        }
        ServiceLoader<T> services = ServiceLoader.load(service, service.getClassLoader());
        for (T t : services) {
            if (filter != null && !filter.test(t)) continue;
            if (result == null) {
                result = t;
                continue;
            }
            throw new ServiceConfigurationError("More than one " + service.getCanonicalName() + " found");
        }
        if (result == null && notNull) {
            throw new ServiceConfigurationError("No one " + service.getCanonicalName() + " found");
        }
        return result;
    }
}

