/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.logging;

import ru.cft.platform.logging.ILogManager;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.ILoggerService;
import ru.cft.platform.logging.ITcm;
import ru.cft.platform.logging.ITcs;
import ru.cft.platform.logging.NullLogManager;
import ru.cft.platform.logging.NullLogger;
import ru.cft.platform.logging.NullTCM;
import ru.cft.platform.logging.NullTCS;
import ru.cft.platform.logging.internal.ServiceUtils;

public class Logger {
    private static final String NO_SERVICE_IMPLEMENTATION = "Error: No one " + ILoggerService.class.getCanonicalName() + " found!";
    private static final String IMPLEMENTATION_DISABLED = "Error: Logging and Logging Thread Context disabled!";
    private static ILoggerService loggerService = ServiceUtils.lookup(ILoggerService.class, null, false);

    public static ILogger getLogger(Class<?> clazz) {
        if (loggerService == null) {
            Logger.error();
            return new NullLogger();
        }
        return loggerService.getLogger(clazz);
    }

    public static ILogger getLogger(String string) {
        if (loggerService == null) {
            Logger.error();
            return new NullLogger();
        }
        return loggerService.getLogger(string);
    }

    public static ILogger getRootLogger() {
        if (loggerService == null) {
            Logger.error();
            return new NullLogger();
        }
        return loggerService.getRootLogger();
    }

    public static ILogManager getLogManager() {
        if (loggerService == null) {
            Logger.error();
            return new NullLogManager();
        }
        return loggerService.getLogManager();
    }

    public static ITcm getTCM() {
        if (loggerService == null) {
            Logger.error();
            return new NullTCM();
        }
        return loggerService.getTCM();
    }

    public static ITcs getTCS() {
        if (loggerService == null) {
            Logger.error();
            return new NullTCS();
        }
        return loggerService.getTCS();
    }

    private static void error() {
        System.err.println(NO_SERVICE_IMPLEMENTATION);
        System.err.println(IMPLEMENTATION_DISABLED);
    }
}

