/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ldap;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import ru.cft.platform.crpwd.crypt.password.CryptPassword;
import ru.cft.platform.jaas.ldap.LDAPAuthenticator;
import ru.cft.platform.jaas.ldap.LDAPLoginException;
import ru.cft.platform.jaas.ldap.LdapPrincipal;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class LdapLoginModule
implements LoginModule {
    private static ILogger logger = Logger.getLogger(LdapLoginModule.class);
    private CallbackHandler callbackHandler;
    protected Subject subject;
    protected String user;
    protected String domain;
    protected String psw;
    protected String readerName;
    protected String readerPass;
    protected Properties properties = new Properties();
    protected boolean succeeded = false;
    protected boolean commitSucceeded = false;
    protected String searchBase;
    protected String filter;
    protected String filterAttr;
    protected TreeMap<String, TreeMap<String, TreeMap<String, String>>> ldapServers;
    protected List<String> blacklist;
    protected List<String> whitelist;
    protected boolean userCaseSensitive;
    public static final String LDAP_HOST = "ldap-host";
    public static final String SEARCH_BASE = "search-base";
    public static final String DEFAULT_DOMAIN = "default-domain";
    public static final String READER_NAME = "reader-name";
    public static final String READER_PASS = "reader-pass";
    public static final String FILTER = "search-filter";
    public static final String FILTERATTR = "search-attribute";
    public static final String BLACKLIST = "memberOf.blacklist";
    public static final String WHITELIST = "memberOf.whitelist";
    private static final String OWNER_PSW_PREFIX = "=";
    protected static final String USER_CASE_SENSITIVE = "user-case-sensitive";
    protected LdapPrincipal principal;
    private mapComparator comparator = new mapComparator();
    private static final int logMsgType = 1;
    private static final int userMsgRype = 2;
    private static final String defaultMsg = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c";
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.fillLdapSettings(options);
        logger.debug("initialize");
    }

    private void fillLdapSettings(Map<String, ?> options) {
        String subTag = null;
        String subName = null;
        String subSubTag = null;
        String subSubName = null;
        if ((options = new HashMap(options)).containsKey(BLACKLIST)) {
            this.blacklist = Arrays.asList(((String)options.get(BLACKLIST)).split(","));
            options.remove(BLACKLIST);
        }
        if (options.containsKey(WHITELIST)) {
            this.whitelist = Arrays.asList(((String)options.get(WHITELIST)).split(","));
            options.remove(WHITELIST);
        }
        if (options.containsKey(USER_CASE_SENSITIVE)) {
            this.userCaseSensitive = Boolean.parseBoolean(options.get(USER_CASE_SENSITIVE).toString());
            options.remove(USER_CASE_SENSITIVE);
        }
        this.ldapServers = new TreeMap(this.comparator);
        for (String key : options.keySet()) {
            TreeMap<String, String> advJaasProperties;
            int a = key.indexOf(".");
            if (a > 0) {
                subTag = key.substring(0, a);
                subName = key.substring(a + 1);
            } else {
                subTag = "main";
                subName = key;
            }
            a = subName.indexOf(".");
            if (a > 0) {
                subSubTag = subName.substring(0, a);
                subSubName = subName.substring(a + 1);
            } else {
                subSubTag = "group1";
                subSubName = key;
            }
            TreeMap<String, TreeMap<String, String>> jaasProperties = this.ldapServers.get(subTag);
            if (jaasProperties == null) {
                jaasProperties = new TreeMap(this.comparator);
                this.ldapServers.put(subTag, jaasProperties);
            }
            if ((advJaasProperties = jaasProperties.get(subSubTag)) == null) {
                advJaasProperties = new TreeMap();
                jaasProperties.put(subSubTag, advJaasProperties);
            }
            advJaasProperties.put(subSubName, (String)options.get(key));
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available");
        }
        Throwable savedException = null;
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
        for (String ldapServer : this.ldapServers.keySet()) {
            TreeMap<String, TreeMap<String, String>> advLdapServers = this.ldapServers.get(ldapServer);
            savedException = null;
            for (String advLdapServer : advLdapServers.keySet()) {
                if (this.succeeded || savedException != null && !(savedException.getCause() instanceof AuthenticationException)) continue;
                try {
                    try {
                        this.callbackHandler.handle(callbacks);
                        this.user = ((NameCallback)callbacks[0]).getName();
                        this.domain = advLdapServers.get(advLdapServer).get(DEFAULT_DOMAIN);
                        this.readerName = advLdapServers.get(advLdapServer).get(READER_NAME);
                        this.readerPass = LdapLoginModule.decrypt(advLdapServers.get(advLdapServer).get(READER_PASS));
                        this.filter = advLdapServers.get(advLdapServer).get(FILTER);
                        this.filterAttr = advLdapServers.get(advLdapServer).get(FILTERATTR);
                        this.parseDomain(this.user);
                        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                        if (tmpPassword == null) {
                            tmpPassword = new char[]{};
                        }
                        this.psw = new String(tmpPassword);
                        ((PasswordCallback)callbacks[1]).clearPassword();
                    }
                    catch (IOException ioe) {
                        logger.error(ioe.getMessage(), (Throwable)ioe);
                        throw new LoginException(ioe.getMessage());
                    }
                    catch (UnsupportedCallbackException uce) {
                        logger.error(uce.getMessage(), (Throwable)uce);
                        throw new LoginException(uce.getMessage());
                    }
                    this.checkSearchBase(advLdapServers.get(advLdapServer).get(SEARCH_BASE));
                    this.doAuthenticate(advLdapServers.get(advLdapServer).get(LDAP_HOST));
                    logger.debug("OS_USER: " + this.user + " OS_DOMAIN: " + this.domain);
                    this.properties.put("OS_USER", this.user);
                    this.properties.put("OS_DOMAIN", this.domain);
                    this.properties.put("CASE_SENSITIVE", (Object)this.userCaseSensitive);
                }
                catch (LDAPLoginException e) {
                    savedException = e;
                }
            }
        }
        if (!this.succeeded) {
            throw savedException;
        }
        return this.succeeded;
    }

    @Override
    public boolean commit() throws LoginException {
        logger.debug("commit: " + this.user);
        if (!this.succeeded) {
            return false;
        }
        this.principal = new LdapPrincipal(this.user, this.domain);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        if (!this.subject.getPrivateCredentials().contains(this.properties)) {
            this.subject.getPrivateCredentials().add(this.properties);
        }
        logger.debug("commit(): put in subject properties.");
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            logger.debug("abort(): clean subject.");
            this.succeeded = false;
            this.cleanState();
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        logger.debug("logout(): clean subject.");
        this.subject.getPrincipals().remove(this.principal);
        this.succeeded = false;
        this.commitSucceeded = false;
        this.cleanState();
        this.principal = null;
        return true;
    }

    private void checkSearchBase(String defSearchBase) {
        if (defSearchBase != null) {
            this.searchBase = defSearchBase;
            return;
        }
        if (this.domain == null) {
            return;
        }
        String[] arr = this.domain.split("\\.");
        if (arr.length == 0) {
            return;
        }
        if (this.searchBase == null) {
            this.searchBase = "";
        }
        for (int i = 0; i < arr.length; ++i) {
            this.searchBase = this.searchBase + (i > 0 ? "," : "") + "dc=" + arr[i];
        }
    }

    private void checkListContains(List<String> memberOf) throws Exception {
        if (!(this.whitelist == null || memberOf != null && LdapLoginModule.isListsIntersects(memberOf, this.whitelist))) {
            throw new Exception("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0441\u0442\u043e\u0438\u0442 \u0432 whitelist \u0433\u0440\u0443\u043f\u043f\u0435");
        }
        if (this.blacklist != null && memberOf != null && LdapLoginModule.isListsIntersects(memberOf, this.blacklist)) {
            throw new Exception("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441\u043e\u0441\u0442\u043e\u0438\u0442 \u0432 blacklist \u0433\u0440\u0443\u043f\u043f\u0435");
        }
    }

    private void doAuthenticate(String ldapHost) throws LDAPLoginException {
        LDAPAuthenticator auth = new LDAPAuthenticator(this.domain, ldapHost, this.searchBase, this.readerName, this.readerPass, this.filter, this.filterAttr);
        try {
            LDAPAuthenticator.LDAPUserData authResult = auth.authenticate(this.user, this.psw);
            if (authResult == null) {
                throw new AuthenticationException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c " + this.domain + "\\" + this.user + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            }
            this.checkListContains(authResult.getMemberOf());
            this.succeeded = true;
        }
        catch (AuthenticationException e) {
            this.cleanState();
            this.succeeded = false;
            AuthenticationExceptenMsg authExcMsg = AuthenticationExceptenMsg.findMsg(e);
            logger.warn(authExcMsg.getMsg(1));
            throw new LDAPLoginException(authExcMsg.getMsg(2), e);
        }
        catch (CommunicationException e) {
            this.cleanState();
            this.succeeded = false;
            logger.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0435\u0434\u043d\u0438\u0435\u043d\u0438\u044f \u0441 \u0445\u043e\u0441\u0442\u043e\u043c LDAP");
            throw new LDAPLoginException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445!", e);
        }
        catch (Exception e) {
            this.cleanState();
            this.succeeded = false;
            logger.warn("Login error for user: " + this.user, (Throwable)e);
            throw new LDAPLoginException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445!", e);
        }
    }

    private void parseDomain(String userString) {
        if (userString == null) {
            return;
        }
        String[] arr = userString.split("\\\\");
        if (arr.length == 2) {
            this.domain = arr[0];
            this.user = arr[1];
        } else {
            this.user = userString;
        }
    }

    protected void cleanState() {
        this.user = null;
        this.domain = null;
        this.psw = null;
        this.searchBase = null;
    }

    private static String decrypt(String pswBase64) {
        if (pswBase64 == null || pswBase64.length() == 0) {
            return pswBase64;
        }
        if (!OWNER_PSW_PREFIX.equals(pswBase64.substring(0, 1))) {
            return pswBase64;
        }
        return LdapLoginModule.decryptIt(pswBase64.substring(1));
    }

    private static String decryptIt(String pswBase64) {
        CryptPassword crypt = new CryptPassword();
        try {
            return crypt.decryptBase64(pswBase64);
        }
        catch (Exception e) {
            System.out.println("20Error decrypt password!");
            e.printStackTrace();
            return pswBase64;
        }
    }

    private static boolean isListsIntersects(List<?> a, List<?> b) {
        for (Object ao : a) {
            if (!b.contains(ao)) continue;
            return true;
        }
        return false;
    }

    private class mapComparator
    implements Comparator<String> {
        private mapComparator() {
        }

        @Override
        public int compare(String first, String second) {
            if (first.equalsIgnoreCase(second)) {
                return 0;
            }
            if (first.equalsIgnoreCase("main")) {
                return -1;
            }
            if (second.equalsIgnoreCase("main")) {
                return 1;
            }
            return first.compareToIgnoreCase(second);
        }
    }

    public static enum AuthenticationExceptenMsg {
        USERNAME_NOT_FOUND(1317, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0435", 1),
        INVALID_PASSWORD(1326, "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d", 1),
        NOT_PERMITTED(1328, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442", 3),
        NOT_PERMITTED_AT_THIS_WORKSTATION(1329, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u0432\u0445\u043e\u0434\u0438\u0442\u044c \u043d\u0430 \u044d\u0442\u0443 \u0440\u0430\u0431\u043e\u0447\u0443\u044e \u0441\u0442\u0430\u043d\u0446\u0438\u044e", 3),
        PASSWORD_EXPIRED(1330, "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f \u0438\u0441\u0442\u0435\u043a", 3),
        ACCOUNT_DISABLED(1331, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d", 3),
        ACCOUNT_EXPIRED(1793, "\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u0441\u0442\u0435\u043a", 3),
        PASSWORD_NEEDS_RESET(1907, "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c", 3),
        ACCOUNT_LOCKED(1909, "\u0423\u0447\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430", 3),
        OTHERS(-1, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c", 3);

        private int code;
        private String msg;
        private int type;

        private AuthenticationExceptenMsg(int code, String msg, int type) {
            this.code = code;
            this.msg = msg;
            this.type = type;
        }

        public String getMsg(int type) {
            if ((this.type & type) != 0) {
                return this.msg;
            }
            return LdapLoginModule.defaultMsg;
        }

        public int getCode() {
            return this.code;
        }

        public static AuthenticationExceptenMsg findMsg(AuthenticationException e) {
            Matcher m = SUB_ERROR_CODE.matcher(e.getMessage());
            int subCode = -1;
            if (m.matches()) {
                subCode = Integer.parseInt(m.group(1), 16);
                for (AuthenticationExceptenMsg msg : AuthenticationExceptenMsg.values()) {
                    if (msg.getCode() != subCode) continue;
                    return msg;
                }
            }
            return OTHERS;
        }
    }
}

