/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.ldap;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class LDAPAuthenticator {
    private static ILogger logger = Logger.getLogger(LDAPAuthenticator.class);
    private String domain;
    private String ldapHost;
    private String searchBase;
    private String filterAttr;
    private String filter;
    private String readerName;
    private String readerPass;
    private String defaultFilter = "(&(objectClass=user))";
    private String defaultFilterAttr = "sAMAccountName";

    public LDAPAuthenticator() {
    }

    public LDAPAuthenticator(String domain, String ldapHost, String searchBase, String readerName, String readerPass, String filter, String filterAttr) {
        this.domain = domain;
        this.ldapHost = ldapHost;
        this.searchBase = searchBase;
        this.readerName = readerName;
        this.readerPass = readerPass;
        this.filterAttr = filterAttr != null ? filterAttr : this.defaultFilterAttr;
        this.filter = filter != null ? filter : this.defaultFilter;
        logger.debug("domain: " + domain + " ldapHost: " + ldapHost + " searchBase: " + searchBase + " readerName: " + readerName + " filter: " + filter + " filterAttr: " + filterAttr);
    }

    public LDAPUserData authenticate(String user, String pass) throws Exception {
        if (pass == null || pass.isEmpty()) {
            throw new AuthenticationException();
        }
        String[] returnedAtts = new String[]{"sAMAccountName", "sn", "givenName", "mail", "memberOf"};
        String searchFilter = this.filter.substring(0, this.filter.length() - 1) + "(" + this.filterAttr + "=" + user + "))";
        SearchControls searchCtls = new SearchControls();
        searchCtls.setReturningAttributes(returnedAtts);
        searchCtls.setSearchScope(2);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapHost);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", (this.readerName != null ? this.readerName : user) + "@" + this.domain);
        env.put("java.naming.security.credentials", this.readerPass != null ? this.readerPass : pass);
        InitialLdapContext ctxGC = null;
        ctxGC = new InitialLdapContext(env, null);
        NamingEnumeration<SearchResult> answer = ctxGC.search(this.searchBase, searchFilter, searchCtls);
        if (answer.hasMoreElements()) {
            SearchResult sr = answer.next();
            Attributes attrs = sr.getAttributes();
            LDAPUserData userData = null;
            if (attrs != null) {
                userData = new LDAPUserData();
                Attribute sAMAccountNameAttribute = attrs.get("sAMAccountName");
                if (sAMAccountNameAttribute != null) {
                    userData.sAMAccountName = sAMAccountNameAttribute.get();
                }
                userData.sAMAccountName = LDAPAuthenticator.getAttributeValue(attrs.get("sAMAccountName"), null);
                userData.sn = LDAPAuthenticator.getAttributeValue(attrs.get("sn"), null);
                userData.givenName = LDAPAuthenticator.getAttributeValue(attrs.get("givenName"), null);
                userData.mail = LDAPAuthenticator.getAttributeValue(attrs.get("mail"), null);
                Attribute memberOfAttribute = attrs.get("memberOf");
                if (memberOfAttribute != null) {
                    ArrayList<String> accountGroups = new ArrayList<String>();
                    NamingEnumeration<?> groups = memberOfAttribute.getAll();
                    while (groups.hasMore()) {
                        Object groupObj = groups.next();
                        if (!(groupObj instanceof String)) continue;
                        String group = (String)groupObj;
                        String[] groupParams = group.split(",");
                        String groupName = groupParams[0];
                        if (groupName != null && groupName.toUpperCase().startsWith("CN=")) {
                            groupName = groupName.substring(3);
                        }
                        accountGroups.add(groupName);
                    }
                    userData.memberOf = accountGroups;
                }
            }
            if (this.readerName != null && this.readerPass != null) {
                env.put("java.naming.security.principal", userData.getsAMAccountName() + "@" + this.domain);
                env.put("java.naming.security.credentials", pass);
                ctxGC = new InitialLdapContext(env, null);
            }
            return userData;
        }
        return null;
    }

    private static Object getAttributeValue(Attribute attr, Object defaultValue) throws NamingException {
        if (attr != null) {
            return attr.get();
        }
        return defaultValue;
    }

    public static class LDAPUserData {
        private Object sAMAccountName;
        private Object sn;
        private Object givenName;
        private Object mail;
        private List<String> memberOf;

        public Object getsAMAccountName() {
            return this.sAMAccountName;
        }

        public Object getSn() {
            return this.sn;
        }

        public Object getGivenName() {
            return this.givenName;
        }

        public Object getMail() {
            return this.mail;
        }

        public List<String> getMemberOf() {
            return this.memberOf;
        }
    }
}

