/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jms.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.cft.platform.jms.api.JMSFactory;
import ru.cft.platform.jms.api.JMSMessage;
import ru.cft.platform.jms.api.JMSMessageListener;
import ru.cft.platform.jms.api.JMSQueue;
import ru.cft.platform.jms.impl.JMSFactoryImpl;
import ru.cft.platform.jms.impl.JMSMessageImpl;
import ru.cft.platform.jms.impl.TextListener;

@WebServlet(name="MessageTester", urlPatterns={"/MessageTester"}, loadOnStartup=1)
public class MessageTester
extends HttpServlet
implements Servlet {
    static final long serialVersionUID = 0L;
    private JMSFactory factory = null;
    private String messageIn = "TestMessage";
    private String queueIn = "jms/Queue";
    private String queueCFIn = "jms/QCF";
    private String username = "";
    private String password = "";
    private String subsID = "";
    private boolean asynchRun = false;

    private StringBuffer writeForm(StringBuffer messageOut) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("<html>\n");
        strBuffer.append("<head>\n");
        strBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">\n");
        strBuffer.append("<title>JMS Test Tool</title>\n");
        strBuffer.append("<script language=\"JavaScript\" type=\"text/javascript\">\n");
        strBuffer.append("\tfunction submitForm(reqType) {\n");
        strBuffer.append("\t\tdocument.forms[0].hReqType.value = reqType;\n");
        strBuffer.append("\t\tdocument.forms[0].submit();\n");
        strBuffer.append("}\n");
        strBuffer.append("</script>\n");
        strBuffer.append("</head>\n");
        strBuffer.append("<body bgcolor=\"#cccccc\" leftmargin=\"4\" topmargin=\"1\">\n");
        strBuffer.append("<form method=\"post\">\n");
        strBuffer.append("<div align=\"center\">\n");
        strBuffer.append("<table border=\"0\" width=\"100%\">\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"center\" valign=\"middle\" nowrap colspan=\"2\">\n");
        strBuffer.append("<h3><font size=\"4\" color=\"#0080ff\" face=\"Verdana\"><b>JMS");
        strBuffer.append("Test Tool</b></font><font size=\"2\" color=\"#000000\" face=\"Verdana\"></font></h3>\n");
        strBuffer.append("</td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><b><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\">Username</font>:</b></td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\"><input type=\"text\" name=\"username\"");
        strBuffer.append("size=\"30\" value=\"" + this.username + "\"><font color=\"gray\" size=\"2\"");
        strBuffer.append("face=\"Verdana\">(If required)</font></font></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><b><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\">Password</font>:</b></td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\"><input type=\"password\" name=\"password\"");
        strBuffer.append("size=\"30\" value=\"" + this.password + "\"></font><font color=\"gray\" size=\"2\"");
        strBuffer.append("face=\"Verdana\">(If required)</font></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><b><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\">Connection Factory</font>:</b></td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\"><input type=\"text\" name=\"txtQCF\"");
        strBuffer.append("size=\"30\" value=\"" + this.queueCFIn + "\"><font color=\"gray\" size=\"2\"");
        strBuffer.append("face=\"Verdana\">(Use JNDI Name or ibmmq connection string)</font></font></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><b><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\">Destination (Queue or Topic)</font>:</b></td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\"><input type=\"text\" name=\"txtQueue\"");
        strBuffer.append("size=\"30\" value=\"" + this.queueIn + "\"></font><font color=\"gray\" size=\"2\"");
        strBuffer.append("face=\"Verdana\">(Use JNDI Name)</font></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><b><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\">Subscription ID</font>:</b></td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\"><input type=\"text\" name=\"txtSubID\"");
        strBuffer.append("size=\"30\" value=\"" + this.subsID + "\"></font><font color=\"gray\" size=\"2\"");
        strBuffer.append("face=\"Verdana\">(Use for topic GET only)</font></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\" nowrap><font color=\"#000000\"");
        strBuffer.append("size=\"2\" face=\"Verdana\"><b> Text:</b></font></td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\"><font size=\"2\" color=\"#000000\"");
        strBuffer.append("face=\"Verdana\"><textarea rows=\"4\" cols=\"60\" name=\"txtMessage\">" + this.messageIn + "</textarea></font></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td colspan=\"2\" align=\"center\" valign=\"middle\" nowrap><input type=\"hidden\" name=\"hReqType\" value=\"Put\"></td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td>&nbsp;</td>\n");
        strBuffer.append("<td align=\"left\" valign=\"top\">");
        strBuffer.append("<font size=\"2\" color=\"#000000\" face=\"Verdana\"><input type=\"button\" name=\"btnPutMessage\" value=\"Put Message\" onclick=\"JavaScript: submitForm('Put');\">");
        strBuffer.append("<input type=\"button\" name=\"btnPutMessageB\" value=\"Put Message As Bytes\" onclick=\"JavaScript: submitForm('PutB');\">");
        strBuffer.append("<input type=\"button\" name=\"btnGetMessage\" value=\"Get message\" onclick=\"JavaScript: submitForm('Get');\"></font></div>\n");
        strBuffer.append("</td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("<tr>\n");
        strBuffer.append("<td colspan=\"2\" align=\"center\" valign=\"middle\">");
        strBuffer.append("<br>\n");
        strBuffer.append("<br>\n");
        strBuffer.append(messageOut);
        strBuffer.append("</td>\n");
        strBuffer.append("</tr>\n");
        strBuffer.append("</table>\n");
        strBuffer.append("</form>\n");
        strBuffer.append("</body>\n");
        strBuffer.append("</html>\n");
        return strBuffer;
    }

    private void printHTML(StringBuffer messageOut, HttpServletResponse res) {
        try {
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            out.println(this.writeForm(messageOut).toString());
            out.close();
        }
        catch (Throwable t) {
            System.out.println(t.getStackTrace());
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block7: {
            try {
                if (req.getParameter("hReqType") == null) {
                    this.printHTML(new StringBuffer(), res);
                    break block7;
                }
                String formAction = req.getParameter("hReqType").trim();
                System.out.println(formAction);
                if (formAction.equals("Put")) {
                    this.produceMsg(req, res, false);
                    break block7;
                }
                if (formAction.equals("PutB")) {
                    this.produceMsg(req, res, true);
                    break block7;
                }
                if (formAction.equals("Get")) {
                    this.consumeMsg(req, res);
                    break block7;
                }
                if (formAction.equals("GetAsync")) {
                    this.consumeMsgAsync(req, res);
                    break block7;
                }
                throw new Exception("That is not a valid option!");
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.out.println(t.getMessage());
                StringBuffer strBuffer = new StringBuffer();
                strBuffer.append("ERROR: In doPost() Routine\n");
                strBuffer.append(t.getMessage());
                this.printHTML(strBuffer, res);
            }
        }
    }

    private void consumeMsg(HttpServletRequest req, HttpServletResponse res) throws Throwable {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("INFO: Consuming a message\n");
        this.username = req.getParameter("username").trim();
        this.password = req.getParameter("password").trim();
        this.queueCFIn = req.getParameter("txtQCF").trim();
        this.queueIn = req.getParameter("txtQueue").trim();
        this.subsID = req.getParameter("txtSubID").trim();
        String messageText = null;
        String error = null;
        try {
            this.factory = this.queueCFIn.startsWith("ibmmq:") ? (JMSFactory)Class.forName("ru.cft.platform.jmqi.jmstools.JMQIFactory").newInstance() : new JMSFactoryImpl();
            JMSQueue queue = this.factory.getQueue(false, this.queueCFIn, this.queueIn, false, this.username, this.password);
            if (this.subsID == null || this.subsID.trim().length() == 0) {
                queue.setSubscriptionID(null);
            } else {
                queue.setSubscriptionID(this.subsID);
            }
            JMSMessage message = queue.getMessage("BYTES", null, Long.valueOf(1L));
            if (message != null) {
                messageText = message.getText();
            }
            queue.closeSession();
            queue.closeConnection();
        }
        catch (Throwable e) {
            e.printStackTrace();
            error = e.getMessage();
        }
        if (messageText == null) {
            strBuffer.append("INFO: No message found on queue!\n");
            if (error != null) {
                strBuffer.append("ERROR:\n" + error + "\n");
            }
        } else {
            strBuffer.append("INFO: Message found on queue.\n");
            strBuffer.append("MESSAGE:\n" + messageText + "\n");
        }
        this.printHTML(strBuffer, res);
    }

    private void consumeMsgAsync(HttpServletRequest req, HttpServletResponse res) throws Throwable {
        if (this.asynchRun) {
            return;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("INFO: Consuming a message async\n");
        this.username = req.getParameter("username").trim();
        this.password = req.getParameter("password").trim();
        this.queueCFIn = req.getParameter("txtQCF").trim();
        this.queueIn = req.getParameter("txtQueue").trim();
        String error = null;
        try {
            this.factory = this.queueCFIn.startsWith("ibmmq:") ? (JMSFactory)Class.forName("ru.cft.platform.jmqi.jmstools.JMQIFactory").newInstance() : new JMSFactoryImpl();
            JMSQueue queue = this.factory.getQueue(false, this.queueCFIn, this.queueIn, false, this.username, this.password);
            queue.addListener((JMSMessageListener)new TextListener());
            queue.closeSession();
            queue.closeConnection();
        }
        catch (Throwable e) {
            e.printStackTrace();
            error = e.getMessage();
        }
        this.asynchRun = true;
        if (error == null) {
            strBuffer.append("INFO: Listener registered.\n");
        } else {
            strBuffer.append("ERROR:\n" + error + "\n");
        }
        this.printHTML(strBuffer, res);
    }

    private void produceMsg(HttpServletRequest req, HttpServletResponse res, boolean bytesMode) throws Throwable {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("INFO: Producing a message\n");
        this.username = req.getParameter("username").trim();
        this.password = req.getParameter("password").trim();
        this.queueCFIn = req.getParameter("txtQCF").trim();
        this.queueIn = req.getParameter("txtQueue").trim();
        this.messageIn = URLDecoder.decode(req.getParameter("txtMessage").trim());
        String messageId = null;
        String error = null;
        try {
            JMSMessageImpl message = new JMSMessageImpl();
            if (bytesMode) {
                message.setBytes(this.messageIn.getBytes());
                message.setMessageType("BYTES");
            } else {
                message.setText(this.messageIn);
                message.setMessageType("TEXT");
            }
            this.factory = this.queueCFIn.startsWith("ibmmq:") ? (JMSFactory)Class.forName("ru.cft.platform.jmqi.jmstools.JMQIFactory").newInstance() : new JMSFactoryImpl();
            JMSQueue queue = this.factory.getQueue(false, this.queueCFIn, this.queueIn, false, this.username, this.password);
            if (queue.putMessage((JMSMessage)message)) {
                messageId = message.getId();
            }
            queue.closeSession();
            queue.closeConnection();
        }
        catch (Throwable e) {
            e.printStackTrace();
            error = e.getMessage();
        }
        if (messageId != null) {
            strBuffer.append("MESSAGE:\n" + this.messageIn);
            strBuffer.append("\n\nINFO: Message put on queue.\n");
            strBuffer.append("\nJMS Message ID=" + messageId);
        } else {
            strBuffer.append("ERROR: " + error);
        }
        this.printHTML(strBuffer, res);
    }
}

