/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jms.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import ru.cft.platform.jms.api.JMSFactory;
import ru.cft.platform.jms.api.JMSMessage;
import ru.cft.platform.jms.api.JMSMessageListener;
import ru.cft.platform.jms.api.JMSQueue;
import ru.cft.platform.jms.impl.JMSMessageImpl;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class JMSQueueImpl
implements JMSQueue {
    private String queueConnectionFactoryName = null;
    private String queueName = null;
    private JMSFactory factory = null;
    ConnectionFactory qcf = null;
    Connection conn = null;
    Session session = null;
    Destination queue = null;
    private boolean inited = false;
    private Throwable error = null;
    private boolean isTraced = false;
    private boolean isDebuged = false;
    private boolean connectionStarted = false;
    private boolean usePrefixJNDI = true;
    private boolean enableTransaction = false;
    private String subscriptionID = null;
    private String username = null;
    private String password = null;
    private static final ILogger logger = Logger.getLogger(JMSQueueImpl.class);
    private List<JMSMessageListener> listeners;

    public JMSMessage getMessage(String messageType, String correlationId, Long timeToWait, String cond) throws Throwable {
        if (!this.inited) {
            throw this.error;
        }
        return this.consumeMsg(messageType, correlationId, timeToWait, cond);
    }

    public JMSMessage getMessage(String messageType, String correlationId, Long timeToWait) throws Throwable {
        if (!this.inited) {
            throw this.error;
        }
        return this.consumeMsg(messageType, correlationId, timeToWait, null);
    }

    public JMSMessage getMessage(String messageType) throws Throwable {
        return this.getMessage(messageType, null, null);
    }

    public JMSMessage getMessage(String messageType, String correlationId) throws Throwable {
        return this.getMessage(messageType, correlationId, null, null);
    }

    public void registerListener(MessageListener listener) throws Throwable {
        if (!this.inited) {
            throw this.error;
        }
        this.regListener(listener);
    }

    public synchronized void addListener(JMSMessageListener listener) throws Throwable {
        if (this.listeners == null) {
            this.listeners = new ArrayList<JMSMessageListener>();
            this.regListener(new DispatchingListener());
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(JMSMessageListener listener) {
        this.listeners.remove(listener);
    }

    public boolean putMessage(JMSMessage message) throws Throwable {
        if (!this.inited) {
            throw this.error;
        }
        return this.produceMsg(message);
    }

    private JMSMessage convert(Message m) throws Throwable {
        if (m == null) {
            return null;
        }
        JMSMessageImpl message = new JMSMessageImpl();
        if (m instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)m;
            message.setText(textMessage.getText().trim());
            message.setMessageType("TEXT");
        } else if (m instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)m;
            byte[] outByteData = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(outByteData);
            message.setBytes(outByteData);
            message.setMessageType("BYTES");
        } else {
            throw new Exception("Message is not of a TextMessage type.");
        }
        message.setId(m.getJMSMessageID());
        message.setCorrId(m.getJMSCorrelationID());
        return message;
    }

    private JMSMessage consumeMsg(String messageType, String correlationId, Long timeToWait, String cond) throws Throwable {
        if (this.factory.getInitialContext() == null) {
            throw this.factory.getError();
        }
        boolean isDebug = logger.isDebugEnabled();
        boolean isTrace = logger.isTraceEnabled();
        this.isDebuged = isDebug;
        this.isTraced = isTrace;
        if (isDebug) {
            logger.debug("Consuming a message (qcf: " + this.queueConnectionFactoryName + ", queue: " + this.queueName + ")");
        }
        Message receivedMessage = this.getMsg(this.queueConnectionFactoryName, this.queueName, correlationId, timeToWait, cond);
        JMSMessage message = null;
        if (receivedMessage == null) {
            if (isDebug) {
                logger.debug("No message found on queue!");
            }
        } else {
            message = this.convert(receivedMessage);
            if (isDebug && message != null) {
                logger.debug(message.getMessageType() + " message found on queue.");
            }
            if (isTrace) {
                logger.trace("MESSAGE:" + message.getText());
            }
        }
        return message;
    }

    private void regListener(MessageListener listener) throws Throwable {
        if (this.factory.getInitialContext() == null) {
            throw this.factory.getError();
        }
        boolean isDebug = logger.isDebugEnabled();
        boolean isTrace = logger.isTraceEnabled();
        this.isDebuged = isDebug;
        this.isTraced = isTrace;
        if (isDebug) {
            logger.debug("Register listener (qcf: " + this.queueConnectionFactoryName + ", queue: " + this.queueName + ")");
        }
        MessageConsumer receiver = null;
        try {
            this.openConnection();
            this.openSession();
            if (isTrace) {
                logger.trace("Creating a Receiver");
            }
            receiver = this.session.createConsumer(this.queue, null);
            if (isTrace) {
                logger.trace("Created a Receiver");
            }
            receiver.setMessageListener(listener);
            this.startConnection();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw t;
        }
        finally {
            this.closeSession();
            this.closeConnection();
        }
    }

    private boolean produceMsg(JMSMessage message) throws Throwable {
        if (this.factory.getInitialContext() == null) {
            throw this.factory.getError();
        }
        boolean isDebug = logger.isDebugEnabled();
        boolean isTrace = logger.isTraceEnabled();
        this.isDebuged = isDebug;
        this.isTraced = isTrace;
        if (isDebug) {
            logger.debug("INFO: Producing a message (qcf: " + this.queueConnectionFactoryName + ", queue: " + this.queueName + ")");
        }
        if (message.getBytes() != null) {
            message.setId(this.putMsg(this.queueConnectionFactoryName, this.queueName, message.getPriority(), message.getTimeToLive(), message.getCorrId(), message.getBytes()));
        } else {
            message.setId(this.putMsg(this.queueConnectionFactoryName, this.queueName, message.getPriority(), message.getTimeToLive(), message.getCorrId(), message.getText()));
        }
        if (isDebug) {
            if (isTrace) {
                logger.trace("MESSAGE:" + message.getText());
            }
            logger.debug("Message put on queue.");
            logger.debug("JMS Message ID=" + message.getId());
        }
        return true;
    }

    private Message getMsg(String getQueueConnectionFactory, String getQueueDestination, String correlationId, Long timeToWait, String cond) throws Throwable {
        boolean isTrace;
        this.isTraced = isTrace = logger.isTraceEnabled();
        MessageConsumer consumer = null;
        try {
            this.openConnection();
            this.openSession();
            if (correlationId != null) {
                if (isTrace) {
                    logger.trace("Creating Consumer with correlationId condition");
                }
                consumer = this.queue instanceof Topic && this.subscriptionID != null ? this.session.createSharedDurableConsumer((Topic)this.queue, this.subscriptionID, "JMSCorrelationID = '" + correlationId + "'" + (cond == null ? null : " and " + cond)) : this.session.createConsumer(this.queue, "JMSCorrelationID = '" + correlationId + "'" + (cond == null ? null : " and " + cond));
            } else {
                if (isTrace) {
                    logger.trace("Creating a Receiver");
                }
                consumer = this.queue instanceof Topic && this.subscriptionID != null ? this.session.createSharedDurableConsumer((Topic)this.queue, this.subscriptionID) : this.session.createConsumer(this.queue, cond);
            }
            if (isTrace) {
                logger.trace("Created a Receiver");
            }
            this.startConnection();
            Message receivedMessage = null;
            if (timeToWait != null && timeToWait > 0L) {
                if (isTrace) {
                    logger.trace("Receiver Message wait: " + timeToWait);
                }
                receivedMessage = consumer.receive(timeToWait * 1000L);
            } else {
                if (isTrace) {
                    logger.trace("Receiver Message nowait");
                }
                receivedMessage = consumer.receiveNoWait();
            }
            if (isTrace) {
                logger.trace("Message Received");
            }
            if (receivedMessage == null) {
                if (isTrace) {
                    logger.trace("No Messages on queue!");
                }
                return null;
            }
            if (isTrace) {
                logger.trace("Message Id: " + receivedMessage.getJMSMessageID().trim());
            }
            return receivedMessage;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw t;
        }
    }

    private String putMsgAdv(String putQueueConnectionFactory, String putQueueDestination, Integer putPriority, Long putTimeToLive, String putCorrId, byte[] inBody, String inText) throws Throwable {
        boolean isTrace;
        this.isTraced = isTrace = logger.isTraceEnabled();
        MessageProducer sender = null;
        try {
            this.openConnection();
            this.openSession();
            if (isTrace) {
                logger.trace("Creating a sender");
            }
            sender = this.session.createProducer(this.queue);
            if (isTrace) {
                logger.trace("Sender created");
            }
            BytesMessage bytesMessage = null;
            TextMessage textMessage = null;
            BytesMessage message = null;
            if (inBody != null) {
                if (isTrace) {
                    logger.trace("Creating a BytesMessage Object");
                }
                bytesMessage = this.session.createBytesMessage();
                if (isTrace) {
                    logger.trace("Created BytesMessage object");
                    logger.trace("Putting message bytes");
                }
                bytesMessage.writeBytes(inBody);
                message = bytesMessage;
            } else {
                if (isTrace) {
                    logger.trace("Creating a TextMessage Object");
                }
                textMessage = this.session.createTextMessage();
                if (isTrace) {
                    logger.trace("Created TextMessage object");
                    logger.trace("Putting message String");
                }
                textMessage.setText(inText);
                message = textMessage;
            }
            this.startConnection();
            if (isTrace) {
                logger.trace("Sending message");
                logger.trace("Message putTimeToLive: " + putTimeToLive);
                logger.trace("Message putPriority: " + putPriority);
                logger.trace("Message putCorrId: " + putCorrId);
            }
            if (putCorrId != null) {
                message.setJMSCorrelationID(putCorrId);
            }
            if (putTimeToLive != null) {
                sender.setTimeToLive(putTimeToLive.longValue());
            }
            sender.send((Message)message, 2, putPriority.intValue(), 0L);
            if (isTrace) {
                logger.trace("Sent message");
            }
            if (isTrace) {
                logger.trace("Getting Message ID");
            }
            String messageID = message.getJMSMessageID().trim();
            if (isTrace) {
                logger.trace("MessageID=" + messageID);
            }
            return messageID;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw t;
        }
    }

    private String putMsg(String putQueueConnectionFactory, String putQueueDestination, Integer putPriority, Long putTimeToLive, String putCorrId, byte[] inBody) throws Throwable {
        return this.putMsgAdv(putQueueConnectionFactory, putQueueDestination, putPriority, putTimeToLive, putCorrId, inBody, null);
    }

    private String putMsg(String putQueueConnectionFactory, String putQueueDestination, Integer putPriority, Long putTimeToLive, String putCorrId, String inText) throws Throwable {
        return this.putMsgAdv(putQueueConnectionFactory, putQueueDestination, putPriority, putTimeToLive, putCorrId, null, inText);
    }

    private void openConnection() throws JMSException {
        if (this.conn != null) {
            return;
        }
        if (this.isTraced) {
            logger.trace("Create Connection to QCF");
        }
        this.conn = this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty() ? this.qcf.createConnection(this.username, this.password) : this.qcf.createConnection();
        if (this.isTraced) {
            logger.trace("Created Connection to QCF");
        }
    }

    private void startConnection() throws JMSException {
        if (this.connectionStarted) {
            return;
        }
        if (this.isTraced) {
            logger.trace("Starting Connection");
        }
        this.conn.start();
        if (this.isTraced) {
            logger.trace("Connection started");
        }
        this.connectionStarted = true;
    }

    private void openSession() throws JMSException {
        if (this.session != null) {
            return;
        }
        if (this.isTraced) {
            logger.trace("Creating a " + (this.enableTransaction ? "" : "non") + " transactional Queue Session");
        }
        this.session = this.enableTransaction ? this.conn.createSession(true, 0) : this.conn.createSession(false, 1);
        if (this.isTraced) {
            logger.trace("Queue Session: Created. Transacted:" + this.session.getTransacted());
        }
    }

    public void closeSession() {
        if (this.session != null) {
            try {
                if (this.isTraced) {
                    logger.trace("Close session. Transacted:" + this.session.getTransacted());
                }
                this.session.close();
                this.session = null;
            }
            catch (Throwable e) {
                logger.warn("Exception when closing session", e);
            }
        }
    }

    public void closeConnection() {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (Throwable e) {
                logger.warn("Exception when closing connection", e);
            }
        }
        this.connectionStarted = false;
    }

    public void reset() throws Throwable {
        this.closeSession();
        this.closeConnection();
        this.init(this.enableTransaction, this.queueConnectionFactoryName, this.queueName, this.factory, this.usePrefixJNDI, this.username, this.password);
    }

    public boolean init(boolean enableTransaction, String queueConnectionFactory, String queueName, JMSFactory factory, boolean usePrefixJNDI, String username, String password) throws Throwable {
        boolean isTrace;
        this.isTraced = isTrace = logger.isTraceEnabled();
        this.queueConnectionFactoryName = queueConnectionFactory;
        this.queueName = queueName;
        this.factory = factory;
        this.usePrefixJNDI = usePrefixJNDI;
        this.enableTransaction = enableTransaction;
        this.username = username;
        this.password = password;
        try {
            if (isTrace) {
                logger.trace("Getting QCF");
            }
            this.qcf = (ConnectionFactory)factory.getInitialContext().lookup((this.usePrefixJNDI ? "java:comp/env/" : "") + this.queueConnectionFactoryName);
            if (isTrace) {
                logger.trace("QCF initial Conext Found");
            }
            if (isTrace) {
                logger.trace("Looking up the Queue Destination");
            }
            this.queue = (Destination)factory.getInitialContext().lookup((this.usePrefixJNDI ? "java:comp/env/" : "") + queueName);
            if (isTrace) {
                logger.trace("Connection established to Queue Destination");
            }
            this.inited = true;
            return true;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            throw t;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.session != null) {
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace("XA commit");
                }
                this.session.commit();
            }
            catch (JMSException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace(e.getMessage());
                }
                throw new XAException(e.getMessage());
            }
            finally {
                this.closeSession();
                this.closeConnection();
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        throw new RuntimeException("end not_implemented");
    }

    public void forget(Xid xid) throws XAException {
        throw new RuntimeException("forget not_implemented");
    }

    public int getTransactionTimeout() throws XAException {
        throw new RuntimeException("getTransactionTimeout not_implemented");
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        throw new RuntimeException("isSameRM not_implemented");
    }

    public int prepare(Xid xid) throws XAException {
        throw new RuntimeException("prepare not_implemented");
    }

    public Xid[] recover(int flag) throws XAException {
        throw new RuntimeException("recover not_implemented");
    }

    public void rollback(Xid xid) throws XAException {
        if (this.session != null) {
            try {
                this.session.rollback();
            }
            catch (JMSException e) {
                throw new XAException(e.getMessage());
            }
            finally {
                this.closeSession();
                this.closeConnection();
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        throw new RuntimeException("setTransactionTimeout not_implemented");
    }

    public void start(Xid xid, int flags) throws XAException {
        throw new RuntimeException("start not_implemented");
    }

    public void setSubscriptionID(String id) {
        this.subscriptionID = id;
    }

    public boolean isSessionTransacted() {
        if (this.session == null) {
            return false;
        }
        try {
            return this.session.getTransacted();
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private class DispatchingListener
    implements MessageListener {
        private DispatchingListener() {
        }

        public void onMessage(Message msg) {
            if (JMSQueueImpl.this.listeners != null) {
                try {
                    JMSMessage m = JMSQueueImpl.this.convert(msg);
                    for (JMSMessageListener l : JMSQueueImpl.this.listeners) {
                        l.onMessage(m);
                    }
                }
                catch (Throwable e) {
                    logger.error("Error on message in listener", e);
                }
            }
        }
    }
}

