/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jms.impl;

import javax.naming.InitialContext;
import ru.cft.platform.jms.api.JMSFactory;
import ru.cft.platform.jms.api.JMSQueue;
import ru.cft.platform.jms.impl.JMSQueueImpl;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class JMSFactoryImpl
implements JMSFactory {
    private InitialContext initialContext = null;
    private static final ILogger logger = Logger.getLogger(JMSFactory.class);
    static final String CONTEXT_PREFIX = "java:comp/env/";
    private Throwable error = null;

    public JMSFactoryImpl() {
        this.init();
    }

    private boolean init() {
        boolean res = false;
        try {
            this.initialContext = new InitialContext();
            res = true;
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
            this.error = t;
        }
        return res;
    }

    public InitialContext getInitialContext() {
        return this.initialContext;
    }

    public Throwable getError() {
        return this.error;
    }

    public JMSQueue getQueue(boolean enableTransaction, String queueConnectionFactory, String queueName) throws Throwable {
        return this.getQueue(enableTransaction, queueConnectionFactory, queueName, false, null, null);
    }

    public JMSQueue getQueue(boolean enableTransaction, String queueConnectionFactory, String queueName, boolean usePrefixJNDI) throws Throwable {
        JMSQueueImpl queue = new JMSQueueImpl();
        queue.init(enableTransaction, queueConnectionFactory, queueName, this, usePrefixJNDI, null, null);
        return queue;
    }

    public JMSQueue getQueue(boolean enableTransaction, String queueConnectionFactory, String queueName, boolean usePrefixJNDI, String username, String password) throws Throwable {
        JMSQueueImpl queue = new JMSQueueImpl();
        queue.init(enableTransaction, queueConnectionFactory, queueName, this, usePrefixJNDI, username, password);
        return queue;
    }
}

