/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.app.runtime;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpRequestBase;
import ru.cft.platform.business.app.runtime.api.HTTP_MGR;
import ru.cft.platform.business.runtime.annotation.CompilerInfo;
import ru.cft.platform.business.runtime.annotation.Redirect;
import ru.cft.platform.business.runtime.method.BusinessPackage;
import ru.cft.platform.core.runtime.type.Boolean;
import ru.cft.platform.core.runtime.type.ITransientPackage;
import ru.cft.platform.core.runtime.type.Null;
import ru.cft.platform.core.runtime.type.Number;
import ru.cft.platform.core.runtime.type.Varchar2;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;
import ru.cft.platform.services.http.HttpManager;
import ru.cft.platform.services.http.exception.ProtocolException;
import ru.cft.platform.services.http.impl.HttpManagerImpl;

@CompilerInfo(compiler="plp2java", version=1)
public class HTTP_MGR
extends BusinessPackage
implements ru.cft.platform.business.app.runtime.api.HTTP_MGR,
ITransientPackage {
    private static final String NULL = "NULL";
    private static final long serialVersionUID = 1L;
    private static final ILogger logger = Logger.getLogger(HTTP_MGR.class);
    private static final int MAX_OPEN_REQUEST = 5;
    private int openRequest = 0;
    private Boolean set_detailed_excp_support = new Boolean(false);
    private HttpManager httpManager = new HttpManagerImpl();

    @Override
    @Redirect(proc="SET_DETAILED_EXCP_SUPPORT")
    public void SET_DETAILED_EXCP_SUPPORT(Boolean enable) {
        logger.debug(String.format("Set set_detailed_excp_support in %s.", enable == null ? NULL : enable.toString()));
        this.set_detailed_excp_support.assign(enable);
    }

    @Override
    @Redirect(proc="GET_DETAILED_EXCP_SUPPORT")
    public void GET_DETAILED_EXCP_SUPPORT(Boolean enable) {
        logger.debug(String.format("Get set_detailed_excp_support = %s.", this.set_detailed_excp_support == null ? NULL : this.set_detailed_excp_support.toString()));
        enable.assign(this.set_detailed_excp_support);
    }

    @Override
    @Redirect(proc="SET_TRANSFER_TIMEOUT")
    public void SET_TRANSFER_TIMEOUT(HTTP_MGR.REQ req, Number timeout) {
        logger.debug("Set transfer timeout.");
        if (req == null || req.getRequest() == null || req.getRequest().isAborted() || timeout == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        if (timeout.isNull_booleanValue()) {
            timeout = new Number(60);
        }
        logger.debug(String.format("%d sec for %s.", timeout.getIntValue(), req.toString()));
        this.httpManager.setTransferTimeout(req.getRequest(), timeout.getIntValue() * 1000);
    }

    @Override
    @Redirect(proc="SET_TRANSFER_TIMEOUT")
    public void SET_TRANSFER_TIMEOUT(Number timeout) {
        logger.debug("Set transfer timeout.");
        if (timeout == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        if (timeout.isNull_booleanValue()) {
            timeout = new Number(60);
        }
        logger.debug(String.format("Set transfer timeout %d sec.", timeout.getIntValue()));
        this.httpManager.setTransferTimeout(timeout.getIntValue() * 1000);
    }

    @Override
    @Redirect(proc="GET_TRANSFER_TIMEOUT")
    public void GET_TRANSFER_TIMEOUT(Number timeout) {
        timeout.assign(this.httpManager.getTransferTimeout() / 1000);
        logger.debug(String.format("Get transfer timeout; timeout = %d sec.", timeout.getIntValue() / 1000));
    }

    @Override
    @Redirect(proc="BEGIN_REQUEST")
    public HTTP_MGR.REQ BEGIN_REQUEST(Varchar2 _url, Varchar2 _method, Varchar2 _http_version, Number _request_context) {
        logger.debug("Begin request.");
        if (this.openRequest >= 5) {
            logger.debug("Faild. You have a maximum number of open requests.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.TOO_MANY_REQUESTS();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        if (_url == null || _url.isNull_booleanValue()) {
            logger.debug("Faild. Bad argument URL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        String http_version = null;
        String method = "GET";
        String url = _url.getValue();
        if (_method != null && !_method.isNull_booleanValue()) {
            method = _method.getValue();
        }
        if (_http_version != null && !_http_version.isNull_booleanValue()) {
            http_version = _http_version.getValue();
        }
        int request_context = _request_context == null || _request_context.isNull_booleanValue() ? 0 : _request_context.getIntValue();
        logger.debug("Apply argument. url: " + url + "; method: " + method + "; http version: " + http_version);
        HttpRequestBase request = this.httpManager.getRequest(url, method, http_version);
        HTTP_MGR.REQ req = new HTTP_MGR.REQ(_url, _method, _http_version, new Number(request_context));
        req.setRequest(request);
        ++this.openRequest;
        logger.debug(String.format("Now %d open requests.", this.openRequest));
        return req;
    }

    @Override
    @Redirect(proc="SET_BODY_CHARSET")
    public void SET_BODY_CHARSET(HTTP_MGR.REQ req, Varchar2 charset) {
        logger.debug(String.format("Set body charset %s for request.", charset == null || charset.getValue() == null ? NULL : charset.getValue()));
        if (req == null || req.getRequest() == null || req.getRequest().isAborted() || charset == null || charset.isNull_booleanValue() || !Charset.isSupported(charset.getValue())) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (charset != null && !Charset.isSupported(charset.getValue())) {
                logger.debug(String.format("Charset %s not supported.", charset.getValue()));
            }
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        req.setCharset(Charset.forName(charset.getValue()));
    }

    @Override
    @Redirect(proc="SET_BODY_CHARSET")
    public void SET_BODY_CHARSET(HTTP_MGR.RESP resp, Varchar2 charset) {
        logger.debug(String.format("Set body charset %s for response.", charset == null || charset.getValue() == null ? NULL : charset.getValue()));
        if (resp == null || charset == null || charset.isNull_booleanValue() || !Charset.isSupported(charset.getValue())) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (charset != null && !Charset.isSupported(charset.getValue())) {
                logger.debug(String.format("Charset %s not supported.", charset.getValue()));
            }
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        resp.setCharset(Charset.forName(charset.getValue()));
    }

    @Override
    @Redirect(proc="END_REQUEST")
    public void END_REQUEST(HTTP_MGR.REQ req) {
        logger.debug("End request.");
        if (req == null || req.getRequest() == null || req.PRIVATE_HNDL == null || req.PRIVATE_HNDL.getValue() == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            return;
        }
        logger.debug(String.format("Request %s.", req.toString()));
        if (req.getRequest() != null && !req.getRequest().isAborted()) {
            req.getRequest().abort();
        }
        this.httpManager.endRequest(req.getRequest());
        req.PRIVATE_HNDL = Null.toNumber();
        req.setRequest(null);
        --this.openRequest;
        logger.debug(String.format("Now %d open requests.", this.openRequest));
    }

    @Override
    @Redirect(proc="SET_HEADER")
    public void SET_HEADER(HTTP_MGR.REQ req, Varchar2 name, Varchar2 value) {
        logger.debug("Set header.");
        if (req == null || req.getRequest() == null || req.getRequest().isAborted() || name == null || name.isNull_booleanValue() || value == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        logger.debug(String.format("Set header for request %s. name=%s; value=%s.", req.toString(), name.toString(), value.toString()));
        this.httpManager.setHeader(req.getRequest(), name.getValue(), value.getValue());
    }

    @Override
    @Redirect(proc="GET_HEADER")
    public void GET_HEADER(HTTP_MGR.RESP resp, Number n, Varchar2 name, Varchar2 value) {
        logger.debug("Get header.");
        if (n == null || n.isNull_booleanValue() || name == null || value == null || resp == null || resp.getResponse() == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        logger.debug(String.format("Get header from response %s. n=%d", resp.toString(), n.getIntValue()));
        Header header = this.httpManager.getHeader(resp.getResponse(), n.getIntValue() + 1);
        if (header == null) {
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.HEADER_NOT_FOUND();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        name.assign(header.getName());
        value.assign(header.getValue());
        logger.debug(String.format("Header name=%s; value=%s.", header.getName(), header.getValue()));
    }

    @Override
    @Redirect(proc="WRITE_TEXT")
    public void WRITE_TEXT(HTTP_MGR.REQ req, Varchar2 data) {
        logger.debug("Write text.");
        if (data == null || req == null || req.getRequest() == null || req.completed || req.getRequest().isAborted()) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        logger.debug(String.format("Write text to request %s.", req.toString()));
        String body = data.isNull_booleanValue() ? "" : data.getValue();
        HttpRequestBase httpRequestBase = req.getCharset() == null ? this.httpManager.writeText(req.getRequest(), body) : this.httpManager.writeText(req.getRequest(), body, req.getCharset());
        req.setRequest(httpRequestBase);
    }

    @Override
    @Redirect(proc="READ_TEXT")
    public void READ_TEXT(HTTP_MGR.RESP resp, Varchar2 data, Number len) {
        logger.debug("Read text.");
        if (resp == null || resp.getResponse() == null || data == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        logger.debug(String.format("Read text from response %s.", resp.toString()));
        int maxLenght = 0;
        int dataSize = data.getSize();
        if (len == null || len.isNull_booleanValue()) {
            maxLenght = dataSize;
        } else {
            maxLenght = len.getIntValue();
            if (dataSize < maxLenght) {
                maxLenght = dataSize;
            }
        }
        String body = "";
        try {
            logger.debug(String.format("Reading %s symbol.", maxLenght));
            body = resp.getCharset() == null ? this.httpManager.readText(resp.getResponse(), maxLenght) : this.httpManager.readText(resp.getResponse(), maxLenght, resp.getCharset());
        }
        catch (IOException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new HTTP_MGR.END_OF_BODY(ex);
        }
        data.assign(body);
    }

    @Override
    @Redirect(proc="GET_RESPONSE")
    public HTTP_MGR.RESP GET_RESPONSE(HTTP_MGR.REQ req, Boolean _return_info_response) {
        HttpResponse tmpResp;
        logger.debug("Get response");
        if (req == null || req.getRequest() == null || req.completed || req.getRequest().isAborted()) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        logger.debug(String.format("Get response from request %s", req.toString()));
        Boolean return_info_response = _return_info_response == null || _return_info_response.isNull_booleanValue() ? Boolean.FALSE : _return_info_response;
        try {
            tmpResp = this.httpManager.getResponse(req.getRequest(), return_info_response.getValue().booleanValue());
        }
        catch (ProtocolException e) {
            throw new HTTP_MGR.REQUEST_FAILED(e);
        }
        catch (IOException e) {
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.TRANSFER_TIMEOUT(e);
            }
            throw new HTTP_MGR.REQUEST_FAILED(e);
        }
        StatusLine statusLine = tmpResp.getStatusLine();
        logger.debug(String.format("Response status: %s", statusLine.toString()));
        HTTP_MGR.RESP response = new HTTP_MGR.RESP(new Number(statusLine.getStatusCode()), new Varchar2(statusLine.getReasonPhrase()), new Varchar2((Object)statusLine.getProtocolVersion()), req.PRIVATE_HNDL);
        response.setResponse(tmpResp);
        response.setRequest(req.getRequest());
        response.setParentRequest(req);
        req.completed = true;
        return response;
    }

    @Override
    @Redirect(proc="END_RESPONSE")
    public void END_RESPONSE(HTTP_MGR.RESP resp) {
        logger.debug("End response.");
        if (resp == null || resp.PRIVATE_HNDL == null || resp.PRIVATE_HNDL.getValue() == null) {
            logger.debug("Faild. Arguments cannot be NULL.");
            return;
        }
        logger.debug(String.format("End response %s.", resp.toString()));
        this.httpManager.endResponse(resp.getResponse());
        if (resp.getRequest() != null && !resp.getRequest().isAborted()) {
            resp.getRequest().abort();
        }
        resp.PRIVATE_HNDL = Null.toNumber();
        resp.setResponse(null);
        resp.setRequest(null);
        this.END_REQUEST(resp.getParentRequest());
    }

    @Override
    @Redirect(proc="SET_PERSISTENT_CONN_SUPPORT")
    public void SET_PERSISTENT_CONN_SUPPORT(Boolean ENABLE, Number MAX_CONNS) {
        MAX_CONNS = MAX_CONNS == null || MAX_CONNS.isNull_booleanValue() ? Number.ZERO() : MAX_CONNS;
        this.httpManager.setPersistentConnSupport(ENABLE.booleanValue(), MAX_CONNS.getIntValue());
    }

    @Override
    @Redirect(proc="SET_PERSISTENT_CONN_SUPPORT")
    public void SET_PERSISTENT_CONN_SUPPORT(HTTP_MGR.REQ req, Boolean ENABLE) {
        if (req == null || req.getRequest() == null || req.getRequest().isAborted()) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        this.httpManager.setPersistentConnSupport((HttpRequest)req.getRequest(), ENABLE.booleanValue());
    }

    @Override
    public void SET_AUTHENTICATION(HTTP_MGR.REQ R, Varchar2 USERNAME, Varchar2 PASSWORD) {
        this.SET_AUTHENTICATION(R, USERNAME, PASSWORD, new Varchar2("Basic"), Boolean.FALSE);
    }

    @Override
    public void SET_AUTHENTICATION(HTTP_MGR.REQ R, Varchar2 USERNAME, Varchar2 PASSWORD, Varchar2 SCHEME) {
        this.SET_AUTHENTICATION(R, USERNAME, PASSWORD, SCHEME, Boolean.FALSE);
    }

    @Override
    public void SET_AUTHENTICATION$def$(HTTP_MGR.REQ R, Varchar2 USERNAME, Varchar2 PASSWORD, Varchar2 SCHEME, Boolean FOR_PROXY, String plp$default$values$) {
        this.SET_AUTHENTICATION(R, USERNAME, PASSWORD, plp$default$values$.charAt(3) == '0' ? new Varchar2("Basic") : SCHEME, plp$default$values$.charAt(4) == '0' ? Boolean.FALSE : FOR_PROXY);
    }

    @Override
    @Redirect(proc="SET_AUTHENTICATION")
    public void SET_AUTHENTICATION(HTTP_MGR.REQ req, Varchar2 username, Varchar2 password, Varchar2 scheme, Boolean forProxy) {
        logger.debug("Set Authentication.");
        if (req == null || req.getRequest() == null || req.getRequest().isAborted() || username == null || username.isNull_booleanValue() || scheme == null || scheme.isNull_booleanValue()) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        if (scheme.ne(new Varchar2("Basic")).booleanValue()) {
            logger.debug("Faild. scheme must be Basic.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        if (forProxy.eq(Boolean.TRUE).booleanValue()) {
            this.httpManager.setProxyAuthentication(username.getValue(), password.getValue());
        } else {
            this.httpManager.setAuthentication(req.getRequest().getURI(), username.getValue(), password.getValue());
        }
    }

    @Override
    @Redirect(proc="SET_PROXY")
    public void SET_PROXY(Varchar2 proxy) {
        logger.debug("Set Proxy.");
        if (proxy == null || proxy.isNull_booleanValue()) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        this.httpManager.setProxy(proxy.getValue());
    }

    @Override
    public void SET_WALLET(Varchar2 PATH) {
        this.SET_WALLET(PATH, plp$const$2, plp$const$2, plp$const$2, plp$const$2);
    }

    @Override
    public void SET_WALLET(Varchar2 PATH, Varchar2 PASSWORD) {
        this.SET_WALLET(PATH, PASSWORD, plp$const$2, plp$const$2, plp$const$2);
    }

    @Override
    public void SET_WALLET(Varchar2 PATH, Varchar2 PASSWORD, Varchar2 KEYSTORE_PATH) {
        this.SET_WALLET(PATH, PASSWORD, KEYSTORE_PATH, plp$const$2, plp$const$2);
    }

    @Override
    public void SET_WALLET(Varchar2 PATH, Varchar2 PASSWORD, Varchar2 KEYSTORE_PATH, Varchar2 KEYSTORE_STOREPASSWORD) {
        this.SET_WALLET(PATH, PASSWORD, KEYSTORE_PATH, KEYSTORE_STOREPASSWORD, plp$const$2);
    }

    @Override
    public void SET_WALLET$def$(Varchar2 PATH, Varchar2 PASSWORD, Varchar2 KEYSTORE_PATH, Varchar2 KEYSTORE_STOREPASSWORD, Varchar2 KEYSTORE_KEYPASSWORD, String plp$default$values$) {
        this.SET_WALLET(PATH, plp$default$values$.charAt(1) == '0' ? plp$const$2 : PASSWORD, plp$default$values$.charAt(2) == '0' ? plp$const$2 : KEYSTORE_PATH, plp$default$values$.charAt(3) == '0' ? plp$const$2 : KEYSTORE_STOREPASSWORD, plp$default$values$.charAt(4) == '0' ? plp$const$2 : KEYSTORE_KEYPASSWORD);
    }

    @Override
    @Redirect(proc="SET_WALLET")
    public void SET_WALLET(Varchar2 path, Varchar2 password, Varchar2 keystore_path, Varchar2 keystore_storePassword, Varchar2 keystore_keyPassword) {
        logger.debug("Set wallet");
        if (path == null || path.isNull_booleanValue() || password == null || password.isNull_booleanValue()) {
            logger.debug("Faild. Arguments cannot be NULL.");
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT();
            }
            throw new HTTP_MGR.REQUEST_FAILED();
        }
        try {
            this.httpManager.setKeystore(path.getValue(), password.getValue(), keystore_path.getValue(), keystore_storePassword.getValue(), keystore_keyPassword.getValue());
        }
        catch (IOException e) {
            if (this.set_detailed_excp_support.booleanValue()) {
                throw new HTTP_MGR.BAD_ARGUMENT(e);
            }
            throw new HTTP_MGR.REQUEST_FAILED(e);
        }
    }

    @Override
    public void initialize() {
    }

    public void deinitialize() {
        this.httpManager.deinitialize();
    }

    @Override
    public String getClassId() {
        return "RUNTIME";
    }

    @Override
    public String getShortName() {
        return "HTTP_MGR";
    }
}

