/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.compiler.java.dynamic;

import java.io.IOException;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import ru.cft.platform.compiler.java.dynamic.ClassLoaderImpl;
import ru.cft.platform.compiler.java.dynamic.Compiler;
import ru.cft.platform.compiler.java.dynamic.CompilerException;
import ru.cft.platform.compiler.java.dynamic.CompilerOptions;
import ru.cft.platform.compiler.java.dynamic.FileManagerImpl;
import ru.cft.platform.compiler.java.dynamic.Source;

public class CompilerImpl
implements Compiler {
    String compileClasspath;
    ClassLoader loader;
    final JavaCompiler compiler;
    DiagnosticCollector<JavaFileObject> diagnostics;
    static final String JAVA_EXTENSION = ".java";
    final ClassLoaderImpl classLoader;
    final CompilerOptions options;
    FileManagerImpl javaFileManager;

    public CompilerImpl() {
        this(null, null);
    }

    public CompilerImpl(ClassLoader loader) {
        this(loader, null);
    }

    public CompilerImpl(ClassLoader loader, CompilerOptions options) {
        this.loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        this.classLoader = new ClassLoaderImpl(loader);
        this.javaFileManager = new FileManagerImpl(fileManager, this.classLoader);
        this.options = options == null ? new CompilerOptions() : options;
    }

    public void setCompileClasspath(String compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    public String getCompileClasspath() {
        return this.compileClasspath;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean compile(List<JavaFileObject> sources) {
        try {
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.javaFileManager, this.diagnostics, this.options.getJavacArgs(), null, sources);
            Boolean bl = task.call();
            return bl;
        }
        finally {
            try {
                this.javaFileManager.close();
                this.javaFileManager = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean addSource(Source source) {
        return false;
    }

    @Override
    public <T> T createInstance(String qualifiedClassName, Class<T> interfaceClass) throws CompilerException, InstantiationException, IllegalAccessException {
        return null;
    }

    @Override
    public Class<?> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return null;
    }

    @Override
    public Class<?> compileClass(String qualifiedClassName) throws CompilerException {
        return null;
    }
}

