/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.compiler.java.dynamic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;

public class CompilerException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Set<String> classNames;
    private transient DiagnosticCollector<JavaFileObject> diagnostics;

    public CompilerException(String message, Set<String> qualifiedClassNames, Throwable cause, DiagnosticCollector<JavaFileObject> diagnostics) {
        super(message, cause);
        this.setClassNames(qualifiedClassNames);
        this.setDiagnostics(diagnostics);
    }

    public CompilerException(String message, Set<String> qualifiedClassNames, DiagnosticCollector<JavaFileObject> diagnostics) {
        super(message);
        this.setClassNames(qualifiedClassNames);
        this.setDiagnostics(diagnostics);
    }

    public CompilerException(Set<String> qualifiedClassNames, Throwable cause, DiagnosticCollector<JavaFileObject> diagnostics) {
        super(cause);
        this.setClassNames(qualifiedClassNames);
        this.setDiagnostics(diagnostics);
    }

    private void setClassNames(Set<String> qualifiedClassNames) {
        this.classNames = new HashSet<String>(qualifiedClassNames);
    }

    private void setDiagnostics(DiagnosticCollector<JavaFileObject> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public DiagnosticCollector<JavaFileObject> getDiagnostics() {
        return this.diagnostics;
    }

    public Collection<String> getClassNames() {
        return Collections.unmodifiableSet(this.classNames);
    }

    public static String diagnosticToString(DiagnosticCollector<JavaFileObject> diagnostics) {
        StringBuilder msgs = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            msgs.append(diagnostic.getMessage(null)).append("\n");
        }
        return msgs.toString();
    }
}

