/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.compiler.java.dynamic;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import ru.cft.platform.compiler.java.dynamic.CharSequenceCompiler;
import ru.cft.platform.compiler.java.dynamic.ClassLoaderImpl;
import ru.cft.platform.compiler.java.dynamic.JavaFileObjectImpl;

final class FileManagerImpl
extends ForwardingJavaFileManager<JavaFileManager> {
    private final ClassLoaderImpl classLoader;
    private final Map<URI, JavaFileObject> fileObjects = new HashMap<URI, JavaFileObject>();

    public FileManagerImpl(JavaFileManager fileManager, ClassLoaderImpl classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileObject o = this.fileObjects.get(this.uri(location, packageName, relativeName));
        if (o != null) {
            return o;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    public void putFileForInput(StandardLocation location, String packageName, String relativeName, JavaFileObject file) {
        this.fileObjects.put(this.uri(location, packageName, relativeName), file);
    }

    private URI uri(JavaFileManager.Location location, String packageName, String relativeName) {
        return CharSequenceCompiler.toURI(location.getName() + '/' + packageName + '/' + relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
        JavaFileObjectImpl file = new JavaFileObjectImpl(qualifiedName, kind);
        this.classLoader.add(qualifiedName, file);
        return file;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject file) {
        String result = file instanceof JavaFileObjectImpl ? file.getName() : super.inferBinaryName(loc, file);
        return result;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> result = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            this.fileObjects.values().forEach(e -> {
                if (e.getKind() == JavaFileObject.Kind.CLASS && e.getName().startsWith(packageName)) {
                    files.add((JavaFileObject)e);
                }
            });
            files.addAll(this.classLoader.files());
        } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject file : this.fileObjects.values()) {
                if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                files.add(file);
            }
            this.fileObjects.values().forEach(e -> {
                if (e.getKind() == JavaFileObject.Kind.SOURCE && e.getName().startsWith(packageName)) {
                    files.add((JavaFileObject)e);
                }
            });
        }
        result.forEach(files::add);
        return files;
    }
}

