/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.compiler.java.dynamic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import ru.cft.platform.compiler.java.dynamic.CompilerException;
import ru.cft.platform.compiler.java.dynamic.CompilerImpl;
import ru.cft.platform.compiler.java.dynamic.CompilerOptions;
import ru.cft.platform.compiler.java.dynamic.JavaFileObjectImpl;

public class CharSequenceCompiler
extends CompilerImpl {
    public CharSequenceCompiler(ClassLoader loader, CompilerOptions options) {
        super(loader, options);
    }

    public synchronized Class<?> compile(String qualifiedClassName, CharSequence javaSource, DiagnosticCollector<JavaFileObject> diagnosticsList, Class<?> ... types) throws CompilerException {
        this.diagnostics = diagnosticsList != null ? diagnosticsList : new DiagnosticCollector();
        HashMap<String, CharSequence> classes = new HashMap<String, CharSequence>(1);
        classes.put(qualifiedClassName, javaSource);
        Map<String, Class<?>> compiled = this.compile(classes, diagnosticsList);
        Class<?> newClass = compiled.get(qualifiedClassName);
        return this.castable(newClass, types);
    }

    public synchronized Map<String, Class<?>> compile(Map<String, CharSequence> classes, DiagnosticCollector<JavaFileObject> diagnosticsList) throws CompilerException {
        ArrayList<JavaFileObject> sources = new ArrayList<JavaFileObject>();
        for (Map.Entry<String, CharSequence> entry : classes.entrySet()) {
            String qualifiedClassName = entry.getKey();
            CharSequence javaSource = entry.getValue();
            if (javaSource == null) continue;
            int dotPos = qualifiedClassName.lastIndexOf(46);
            String className = dotPos == -1 ? qualifiedClassName : qualifiedClassName.substring(dotPos + 1);
            String packageName = dotPos == -1 ? "" : qualifiedClassName.substring(0, dotPos);
            JavaFileObjectImpl source = new JavaFileObjectImpl(className, javaSource);
            sources.add(source);
            this.javaFileManager.putFileForInput(StandardLocation.SOURCE_PATH, packageName, className + ".java", source);
        }
        Boolean result = this.compile(sources);
        if (result == null || !result.booleanValue()) {
            throw new CompilerException("Compilation failed.", classes.keySet(), (DiagnosticCollector<JavaFileObject>)this.diagnostics);
        }
        try {
            HashMap compiled = new HashMap();
            for (String qualifiedClassName : classes.keySet()) {
                Class<?> newClass = this.loadClass(qualifiedClassName);
                compiled.put(qualifiedClassName, newClass);
            }
            return compiled;
        }
        catch (ClassNotFoundException | IllegalArgumentException | SecurityException e) {
            throw new CompilerException(classes.keySet(), e, (DiagnosticCollector<JavaFileObject>)this.diagnostics);
        }
    }

    @Override
    public Class<?> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.classLoader.loadClass(qualifiedClassName);
    }

    private Class<?> castable(Class<?> newClass, Class<?> ... types) {
        for (Class<?> type : types) {
            if (type.isAssignableFrom(newClass)) continue;
            throw new ClassCastException(type.getName());
        }
        return newClass;
    }

    static URI toURI(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.javaFileManager.getClassLoader();
    }
}

