/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.dbchangenotification;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import org.apache.log4j.Logger;

public class DBChangeNotification {
    private static final Logger logger = Logger.getLogger(DBChangeNotification.class);
    private static final String PROPERTY_NAME = "database";
    private static HashMap<String, DatabaseChangeRegistration> dcrMap = new HashMap();

    private static DatabaseChangeRegistration getDCR(OracleConnection connection) throws SQLException {
        String key = connection.getProperties().getProperty(PROPERTY_NAME);
        if (key != null && dcrMap.containsKey(key)) {
            return dcrMap.get(key);
        }
        Properties prop = new Properties();
        prop.setProperty("DCN_NOTIFY_ROWIDS", "true");
        DatabaseChangeRegistration dcr = connection.registerDatabaseChangeNotification(prop);
        dcrMap.put(key.toString(), dcr);
        return dcr;
    }

    private static void removeDCR(OracleConnection connection) {
        String key = connection.getProperties().getProperty(PROPERTY_NAME);
        if (key != null) {
            dcrMap.remove(key);
        }
    }

    public static void registerDatabaseChangeNotification(OracleConnection connection) throws SQLException {
        DBChangeNotification.getDCR(connection);
    }

    public static void unregisterDatabaseChangeNotification(OracleConnection connection) throws SQLException {
        DatabaseChangeRegistration dcr = DBChangeNotification.getDCR(connection);
        if (connection != null && dcr != null) {
            connection.unregisterDatabaseChangeNotification(dcr);
            DBChangeNotification.removeDCR(connection);
        }
    }

    public static void registerNotification(String tableName, OracleConnection connection, DatabaseChangeListener dbcnListener) throws SQLException {
        logger.info((Object)("Start registration notification for table " + tableName + "."));
        DatabaseChangeRegistration dcr = null;
        try {
            dcr = DBChangeNotification.getDCR(connection);
            dcr.addListener(dbcnListener);
            Statement stmt = connection.createStatement();
            ((OracleStatement)stmt).setDatabaseChangeRegistration(dcr);
            ResultSet rs = stmt.executeQuery("select 1 from " + tableName + " where 1=2");
            rs.next();
            String[] tableNames = dcr.getTables();
            for (int i = 0; i < tableNames.length; ++i) {
                logger.info((Object)(tableNames[i] + " is part of the registration."));
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            logger.error((Object)("Registration error for table " + tableName + "."), (Throwable)e);
            throw e;
        }
    }

    public static void unregisterNotification(String tableName, OracleConnection connection, DatabaseChangeListener dbcnListener) throws SQLException {
        logger.info((Object)("unRegistration notification for table " + tableName + "."));
        DatabaseChangeRegistration dcr = null;
        try {
            dcr = DBChangeNotification.getDCR(connection);
            dcr.removeListener(dbcnListener);
        }
        catch (SQLException e) {
            logger.error((Object)("Registration error for table " + tableName + "."), (Throwable)e);
            throw e;
        }
    }
}

