/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.crypto.bcr.proxy;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import ru.cft.platform.core.container.OperationContext;
import ru.cft.platform.core.runtime.exception.CoreRuntimeException;
import ru.cft.platform.core.runtime.standard;
import ru.cft.platform.core.runtime.type.Boolean;
import ru.cft.platform.core.runtime.type.Null;
import ru.cft.platform.core.runtime.type.Number;
import ru.cft.platform.core.runtime.type.Raw;
import ru.cft.platform.core.runtime.type.Varchar2;
import ru.cft.platform.core.runtime.util.Statement;
import ru.cft.platform.core.runtime.util.UtlRaw;
import ru.cft.platform.crypto.api.CryptoDriver;

public class ProxyCryptoDriver
implements CryptoDriver {
    private static final Varchar2 CL8MSWIN1251 = new Varchar2("CL8MSWIN1251");
    private final Varchar2 bcr_characterset = CL8MSWIN1251;
    private final Varchar2 db_characterset = Null.toVarchar2();
    private final Varchar2 bcr_logname = new Varchar2();
    private final Number bcr_loglevel = new Number();
    private final Varchar2 bcr_host = new Varchar2();
    private final Varchar2 bcr_port = new Varchar2();

    private Connection c() {
        return OperationContext.get().getCurrentConnection();
    }

    public void set_characterset(Varchar2 p_characterset) {
        if (p_characterset.isNull_booleanValue()) {
            this.bcr_characterset.assign(CL8MSWIN1251);
        } else {
            this.bcr_characterset.assign(p_characterset);
        }
    }

    public Varchar2 get_characterset() {
        return this.bcr_characterset;
    }

    public void set_db_characterset(Varchar2 p_db_characterset) {
        this.db_characterset.assign(p_db_characterset);
    }

    public Varchar2 get_db_characterset() {
        return this.db_characterset;
    }

    public void set_logname(Varchar2 p_bcr_logname) {
        this.bcr_logname.assign(p_bcr_logname);
    }

    public Varchar2 get_logname() {
        return this.bcr_logname;
    }

    public void set_loglevel(Number p_bcr_loglevel) {
        this.bcr_loglevel.assign(p_bcr_loglevel);
    }

    public Number get_loglevel() {
        return this.bcr_loglevel;
    }

    public void set_host(Varchar2 p_bcr_host) {
        this.bcr_host.assign(p_bcr_host);
    }

    public Varchar2 get_host() {
        return this.bcr_host;
    }

    public void set_port(Varchar2 p_bcr_port) {
        this.bcr_port.assign(p_bcr_port);
    }

    public Varchar2 get_port() {
        return this.bcr_port;
    }

    public Number begin(Varchar2 logname, Number loglevel, Varchar2 host, Varchar2 port) {
        this.set_logname(logname);
        this.set_loglevel(loglevel);
        this.set_host(host);
        this.set_port(port);
        return Number.ZERO();
    }

    public Number sign_data(Varchar2 key_id, Raw data, Raw sign) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_sign_data(crypto_bcr.bcr_begin(?, ?, ?, ?), ?, ?, ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)key_id);
            Statement.set((PreparedStatement)cs, (int)i++, (Raw)data);
            Statement.register((CallableStatement)cs, (int)i, Raw.class);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            Statement.get((CallableStatement)cs, (int)i, (Raw)sign);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_sign_data call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public Number verify_data_sign(Varchar2 sign_dat, Object data, Raw sign, Varchar2 p_characterset, Raw key_id) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_verify_data_sign(crypto_bcr.bcr_begin(?, ?, ?, ?), ?, ?, ?, ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Varchar2 p_sign_dat = standard.convert((Varchar2)sign_dat, (Varchar2)this.bcr_characterset, (Varchar2)this.db_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)p_sign_dat);
            if (data instanceof Varchar2) {
                Varchar2 p_data = new Varchar2();
                if (!p_characterset.isNull_booleanValue()) {
                    p_data = standard.convert((Varchar2)((Varchar2)data), (Varchar2)p_characterset, (Varchar2)this.db_characterset);
                } else {
                    p_data.assign(data);
                }
                Statement.set((PreparedStatement)cs, (int)i++, (Raw)UtlRaw.cast_to_raw((Varchar2)p_data));
            } else {
                Statement.set((PreparedStatement)cs, (int)i++, (Raw)((Raw)data));
            }
            Statement.set((PreparedStatement)cs, (int)i++, (Raw)sign);
            Statement.register((CallableStatement)cs, (int)i, Raw.class);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            Statement.get((CallableStatement)cs, (int)i, (Raw)key_id);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_verify_data_sign call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public Number sign_file(Varchar2 key_id, Varchar2 file) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_sign_file(crypto_bcr.bcr_begin(?, ?, ?, ?), ?, ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)key_id);
            Statement.set((PreparedStatement)cs, (int)i, (Varchar2)file);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_sign_file call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public Number verify_file_sign(Varchar2 sign_dat, Varchar2 file, Number rm_sign, Raw key_id) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_verify_file_sign(crypto_bcr.bcr_begin(?, ?, ?, ?), convert(?, ?, ?), convert(?, ?, ?), ?, ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)sign_dat);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.db_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)file);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.db_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)rm_sign);
            Statement.register((CallableStatement)cs, (int)i, Raw.class);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            Statement.get((CallableStatement)cs, (int)i, (Raw)key_id);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_verify_file_sign call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public Number hash_file(Varchar2 p_file_path, Raw p_file_hash) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_hash_file(crypto_bcr.bcr_begin(?, ?, ?, ?), convert(?, ?, ?), ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)p_file_path);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.db_characterset);
            Statement.register((CallableStatement)cs, (int)i, Raw.class);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            Statement.get((CallableStatement)cs, (int)i, (Raw)p_file_hash);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_hash_file call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public Number check_file_signs(Varchar2 sign_dat, Varchar2 file, Number rm_sign, Varchar2 signs, Raw stats) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_check_file_signs(crypto_bcr.bcr_begin(?, ?, ?, ?), convert(?, ?, ?), convert(?, ?, ?), ?, convert(?, ?, ?), ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)sign_dat);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.db_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)file);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.db_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)rm_sign);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)signs);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_characterset);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.db_characterset);
            Statement.register((CallableStatement)cs, (int)i, Raw.class);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            Statement.get((CallableStatement)cs, (int)i, (Raw)stats);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_check_file_signs call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public Number err_msg(Raw msg) {
        Number number;
        Number result = Null.toNumber();
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin ? := crypto_bcr.bcr_err_msg(crypto_bcr.bcr_begin(?, ?, ?, ?), ?); end;");
            Statement.register((CallableStatement)cs, (int)i++, Number.class);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_port);
            Statement.register((CallableStatement)cs, (int)i, Raw.class);
            cs.executeUpdate();
            Statement.get((CallableStatement)cs, (int)1, (Number)result);
            Statement.get((CallableStatement)cs, (int)i, (Raw)msg);
            number = result;
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_err_msg call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
        return number;
    }

    public void end() {
        CallableStatement cs = null;
        int i = 1;
        try {
            cs = this.c().prepareCall("begin crypto_bcr.bcr_end(crypto_bcr.bcr_begin(?, ?, ?, ?)); end;");
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_logname);
            Statement.set((PreparedStatement)cs, (int)i++, (Number)this.bcr_loglevel);
            Statement.set((PreparedStatement)cs, (int)i++, (Varchar2)this.bcr_host);
            Statement.set((PreparedStatement)cs, (int)i, (Varchar2)this.bcr_port);
            cs.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new CoreRuntimeException("crypto_bcr.bcr_end call", e);
            }
            catch (Throwable throwable) {
                Statement.close(cs);
                throw throwable;
            }
        }
        Statement.close((java.sql.Statement)cs);
    }

    public Boolean connected() {
        return Boolean.FALSE;
    }

    public void release() {
    }
}

