/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.crpwd.crypt.password;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Random;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import ru.cft.platform.crpwd.crypt.password.gui.CryptPasswordForm;
import ru.cft.platform.crpwd.util.Base64;
import ru.cft.platform.crpwd.util.Slog;

public class CryptPassword {
    private String file = null;
    private String pwd = null;
    private int count = 232;
    private byte[] initKey = new byte[]{2, 5, 34, 47, 67, 32, 12, 34, 56, 90, 123, 43, 25, 31, 68, 75, 81, 29, 20, 11, 101, 95, 84, 91, 86, 94, 35, 32, 16, 19, 40, 70, 68, 45, 37, 83, 57, 82, 116, 1, 54, 118, 3, 7, 80, 106, 120, 4, 61, 27, 64, 34, 70, 49, 52, 26, 85, 97, 100, 9, 83, 57, 82, 16, 1, 12, 34, 56, 90, 13, 84, 91, 86, 94, 18, 10, 4, 78, 3, 7, 80, 119, 3, 7, 80, 32, 12, 34, 56, 90, 123, 43, 2, 32, 16, 19, 40, 70, 68, 45};
    private int radix = 256;

    public void setKey(byte[] key) {
        this.initKey = key;
    }

    public byte[] getKey() {
        return this.initKey;
    }

    private String getParam(int trySize, String requestMessage) throws Exception {
        String result = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        PrintStream out = System.out;
        String str = null;
        for (int i = 0; i < trySize; ++i) {
            out.print(requestMessage + " (try is " + (i + 1) + ") : ");
            try {
                result = in.readLine();
                if (str != null) {
                    if (str.equals(result)) continue;
                    throw new Exception("Wrong parameter ! Try once more.");
                }
                str = result;
                continue;
            }
            catch (IOException e) {
                out.println("Init. ERROR = " + e.getMessage());
                e.printStackTrace(out);
            }
        }
        return result;
    }

    private void setArgs(String[] args) {
        try {
            this.pwd = null;
            this.file = null;
            if (args.length > 0) {
                this.file = args[0];
            }
            if (args.length > 1) {
                this.pwd = args[1];
            }
            if (this.file.equals("%1")) {
                this.file = args[0];
            }
            if (args.length > 1) {
                this.pwd = args[1];
            }
            if (this.file == null) {
                this.file = this.getParam(1, "File name");
            }
            if (this.pwd == null) {
                this.pwd = this.getParam(2, "Crypt string");
            }
            Slog.println("File = " + this.file);
            Slog.println("name = " + this.pwd);
        }
        catch (Exception e) {
            System.out.println("ERROR = " + e.getMessage());
            System.exit(12);
        }
    }

    public String load() throws Exception {
        Slog.println("load: Start");
        String result = "";
        try {
            File f = new File(this.file);
            FileInputStream fis = new FileInputStream(f);
            byte[] buf = new byte[(int)f.length()];
            fis.read(buf);
            result = this.decrypt(buf);
        }
        catch (Exception e) {
            System.out.println("Load. ERROR = " + e.getMessage());
            e.printStackTrace(System.out);
            throw e;
        }
        finally {
            Slog.println("load: Finish");
        }
        return result;
    }

    public String decryptBase64(String pwd) throws Exception {
        return this.decrypt(Base64.decode(pwd));
    }

    public String decrypt(byte[] pwd) throws Exception {
        int i;
        Slog.println("decrypt: Start");
        int pwdLen = pwd.length;
        int blockLen = pwdLen / this.count;
        Slog.println("decrypt: pwdLen = " + pwdLen + ", blockLen = " + blockLen);
        if (pwdLen == 0 || blockLen == 0) {
            throw new Exception("Decrypt: Result length is 0.");
        }
        Slog.println("decrypt: create Key");
        byte[] key = new byte[blockLen];
        for (i = 0; i < blockLen; ++i) {
            key[i] = this.initKey[i];
        }
        Slog.println("decrypt: Decrypt");
        for (i = 0; i < pwdLen; i += blockLen) {
            for (int j = 0; j < blockLen; ++j) {
                int n = j;
                key[n] = (byte)(key[n] ^ pwd[i + j]);
            }
        }
        String result = new String(key);
        Slog.println("decrypt: Finish");
        return result;
    }

    private void save() {
        Slog.println("save: Start");
        try {
            byte[] pwdName = this.crypt(this.pwd);
            Slog.println("pwd = " + this.printArray(pwdName));
            this.saveToFileBase64(pwdName);
        }
        catch (Exception e) {
            System.out.println("Save. ERROR = " + e.getMessage());
            System.exit(15);
        }
        Slog.println("save: Finish");
    }

    private void saveToFile(byte[] pwdName) throws Exception {
        this.saveToFile(pwdName, this.file);
    }

    private void saveToFileBase64(byte[] pwdName) throws Exception {
        this.saveToFileBase64(pwdName, this.file);
    }

    public void saveToFile(byte[] pwdName, String fileName) throws Exception {
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(pwdName);
        fos.flush();
        fos.close();
    }

    public void saveToFileBase64(byte[] pwdName, String fileName) throws Exception {
        this.saveToFile(Base64.encode(pwdName).getBytes(), fileName);
    }

    private byte[] getByteSize(int length) {
        byte[] result = new byte[2];
        short slength = (short)length;
        result[1] = (byte)(slength % this.radix);
        result[0] = (byte)(slength / this.radix);
        return result;
    }

    private String printArray(byte[] array) {
        String result = "";
        if (array == null) {
            return result;
        }
        for (int i = 0; i < array.length; ++i) {
            String str = Integer.toHexString(array[i]);
            if (str.length() > 2) {
                str = str.substring(str.length() - 2);
            }
            result = result + str + " ";
        }
        return result;
    }

    public byte[] crypt(String pname) throws Exception {
        int i;
        Slog.println("crypt: Start");
        int passLen = pname.length();
        int initLen = this.initKey.length;
        if (passLen > initLen) {
            throw new Exception("Password length too long (must be less then " + initLen + ").");
        }
        byte[] result = new byte[this.count * passLen];
        int resultLen = result.length;
        Random rand = new Random();
        rand.nextBytes(result);
        byte[] bp = pname.getBytes();
        Slog.println("bp_name  = " + this.printArray(bp));
        Slog.println("result (ish1) = " + this.printArray(result));
        System.arraycopy(bp, 0, result, resultLen - passLen, passLen);
        Slog.println("result (ish2) = " + this.printArray(result));
        byte[] key = new byte[passLen];
        for (i = 0; i < passLen; ++i) {
            key[i] = this.initKey[i];
        }
        for (i = 0; i < resultLen; i += passLen) {
            for (int j = 0; j < passLen; ++j) {
                int n = i + j;
                result[n] = (byte)(result[n] ^ key[j]);
                int n2 = j;
                key[n2] = (byte)(key[n2] ^ result[i + j]);
            }
        }
        Slog.println("crypt: Finish");
        return result;
    }

    public void setFile(String fileName) {
        this.file = fileName;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            new CryptPasswordForm();
        } else {
            Slog.println("main. Start");
            try {
                CryptPassword crypt = new CryptPassword();
                crypt.setArgs(args);
                crypt.save();
                String result = crypt.load();
                Slog.println("dec pwd = " + result);
                Slog.println("main. Finish");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }
}

