/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.runtime.util;

import java.util.ArrayList;

public class CallStackUtil {
    public static String getCallStackAsString() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String[] array = CallStackUtil.getCallStackAsStringArray(stackTraceElements);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i] + "\n");
        }
        return sb.toString();
    }

    public static String getCallStackAsString(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        String[] array = CallStackUtil.getCallStackAsStringArray(stackTraceElements);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i] + "\n");
        }
        return sb.toString();
    }

    public static String[] getCallStackAsStringArray() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String[] array = CallStackUtil.getCallStackAsStringArray(stackTraceElements);
        return array;
    }

    private static String[] getCallStackAsStringArray(StackTraceElement[] stackTraceElements) {
        ArrayList<String> list = new ArrayList<String>();
        String[] array = new String[1];
        for (int i = 0; i < stackTraceElements.length; ++i) {
            StackTraceElement element = stackTraceElements[i];
            String classname = element.getClassName();
            String methodName = element.getMethodName();
            int lineNumber = element.getLineNumber();
            list.add(classname + "." + methodName + ":" + lineNumber);
        }
        return list.toArray(array);
    }
}

