/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.runtime.util;

public class Hex {
    public static String stringToHex(String base) {
        StringBuffer buffer = new StringBuffer();
        for (int x = 0; x < base.length(); ++x) {
            int cursor = 0;
            int intValue = base.charAt(x);
            String binaryChar = new String(Integer.toBinaryString(base.charAt(x)));
            for (int i = 0; i < binaryChar.length(); ++i) {
                if (binaryChar.charAt(i) != '1') continue;
                ++cursor;
            }
            if (cursor % 2 > 0) {
                intValue += 128;
            }
            buffer.append(Integer.toHexString(intValue) + " ");
        }
        return buffer.toString();
    }

    public static String hexToString(String input, int groupLength) {
        String data = input.replace(" ", "").replace("\r\n", "");
        StringBuilder sb = new StringBuilder(data.length() / groupLength);
        for (int i = 0; i < data.length() - groupLength + 1; i += groupLength) {
            String hex = data.substring(i, i + groupLength);
            sb.append((char)Integer.parseInt(hex, 16));
        }
        return sb.toString();
    }

    public static String encodeHexString(byte[] rawData) {
        StringBuffer hexText = new StringBuffer();
        String initialHex = null;
        int initHexLength = 0;
        for (int i = 0; i < rawData.length; ++i) {
            int positiveValue = rawData[i] & 0xFF;
            initialHex = Integer.toHexString(positiveValue);
            initHexLength = initialHex.length();
            while (initHexLength++ < 2) {
                hexText.append("0");
            }
            hexText.append(initialHex);
        }
        return hexText.toString();
    }

    public static String encodeHexString(String sourceText) {
        return Hex.encodeHexString(sourceText.getBytes());
    }

    public static String decodeHexString(String hexText) {
        String decodedText = null;
        String chunk = null;
        if (hexText != null && hexText.length() > 0) {
            int numBytes = hexText.length() / 2;
            byte[] rawToByte = new byte[numBytes];
            int offset = 0;
            for (int i = 0; i < numBytes; ++i) {
                chunk = hexText.substring(offset, offset + 2);
                offset += 2;
                rawToByte[i] = (byte)(Integer.parseInt(chunk, 16) & 0xFF);
            }
            decodedText = new String(rawToByte);
        }
        return decodedText;
    }

    public static byte[] decodeHexStringToByte(String hexText) {
        String chunk = null;
        if (hexText != null && hexText.length() > 0) {
            int numBytes = hexText.length() / 2;
            byte[] rawToByte = new byte[numBytes];
            int offset = 0;
            for (int i = 0; i < numBytes; ++i) {
                chunk = hexText.substring(offset, offset + 2);
                offset += 2;
                rawToByte[i] = (byte)(Integer.parseInt(chunk, 16) & 0xFF);
            }
            return rawToByte;
        }
        return null;
    }
}

