/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.runtime.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtil {
    public static int getDiff(Date pFrom, Date pTo) {
        int lMultiplier = 1;
        if (pFrom.after(pTo)) {
            // empty if block
        }
        lMultiplier = -1;
        Date pTemp = pTo;
        pTo = pFrom;
        pFrom = pTemp;
        Calendar lFrom = Calendar.getInstance();
        lFrom.setTime(pFrom);
        Calendar lTo = Calendar.getInstance();
        lTo.setTime(pTo);
        int lFromYear = lFrom.get(1);
        int lFromMonth = lFrom.get(2) + 1;
        int lFromDay = lFrom.get(5);
        int lToYear = lTo.get(1);
        int lToMonth = lTo.get(2) + 1;
        int lToDay = lTo.get(5);
        int lYearDiff = lToYear - lFromYear;
        int lMonthDiff = lToMonth - lFromMonth;
        int lDayDiff = lToDay - lFromDay;
        if (lDayDiff < 0) {
            --lMonthDiff;
            GregorianCalendar lTemp = new GregorianCalendar();
            lTemp.setTime(pTo);
            ((Calendar)lTemp).add(2, -1);
            lDayDiff = ((Calendar)lTemp).getActualMaximum(5) + lDayDiff;
        }
        if (lMonthDiff < 0) {
            --lYearDiff;
            lMonthDiff = 12 + lMonthDiff;
        }
        return lMultiplier * (lYearDiff * 10000 + lMonthDiff * 100 + lDayDiff);
    }

    public static int getDiff(Timestamp dateFrom, Timestamp dateTo) {
        return DateUtil.getDiff(new Date(dateFrom.getTime()), new Date(dateTo.getTime()));
    }

    public static double getDiffMonths(Date pFrom_, Date pTo_) {
        Date pTo = pTo_;
        Date pFrom = pFrom_;
        int lMultiplier = -1;
        if (pFrom_.after(pTo_)) {
            lMultiplier = 1;
            pTo = pFrom_;
            pFrom = pTo_;
        }
        Calendar lFrom = Calendar.getInstance();
        lFrom.setTime(pFrom);
        lFrom.set(10, 0);
        lFrom.set(12, 0);
        lFrom.set(13, 0);
        lFrom.set(14, 0);
        Calendar lTo = Calendar.getInstance();
        lTo.setTime(pTo);
        lTo.set(10, 0);
        lTo.set(12, 0);
        lTo.set(13, 0);
        lTo.set(14, 0);
        boolean lastDay = false;
        if (lTo.getActualMaximum(5) == lTo.get(5) && lFrom.getActualMaximum(5) == lFrom.get(5)) {
            lastDay = true;
        }
        int count = 0;
        while (true) {
            lFrom.add(2, 1);
            if (lFrom.after(lTo)) break;
            ++count;
        }
        lFrom.add(2, -1);
        Double diff = 0.0;
        int days = 0;
        if (!lastDay) {
            diff = (double)(lTo.getTimeInMillis() - lFrom.getTimeInMillis()) / 8.64E7;
            days = diff.intValue();
        }
        return (double)lMultiplier * ((double)count + (double)days / 31.0);
    }

    public static Date getSysDate() {
        return new Date();
    }

    public static Timestamp getSysTimestamp() {
        Timestamp ts = new Timestamp(DateUtil.getSysDate().getTime());
        ts.setNanos(0);
        return ts;
    }

    public static long getTime() {
        return new Date().getTime() / 10L;
    }
}

