/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.runtime.exception;

import java.sql.SQLException;

public class CoreRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static int WRAPPER_ERROR_CODE = -30000;
    public static int OTHER_EXCEPTION_ERROR_CODE = -20999;
    public static final int NO_DATA_FOUND = 100;
    public static int TOO_MANY_ROWS = -1422;
    public static int VALUE_ERROR = -6502;
    public static int INVALID_ARGVAL = -21560;
    public static int CANNOT_INSERT_NULL = -1400;
    public static final String DEFAULT_MESSAGE = "User-Defined Exception";
    public static final int DEFAULT_CODE = 1;
    private int errorCode = 1;
    private String id;

    public CoreRuntimeException(int errorCode) {
        super(DEFAULT_MESSAGE);
        this.errorCode = errorCode;
    }

    public CoreRuntimeException(int errorCode, Throwable e) {
        super(DEFAULT_MESSAGE, e);
        this.errorCode = errorCode;
    }

    public CoreRuntimeException(String id) {
        super(DEFAULT_MESSAGE);
        this.id = id;
    }

    public CoreRuntimeException(String id, int errorCode) {
        super(DEFAULT_MESSAGE);
        this.errorCode = errorCode;
        this.id = id;
    }

    public CoreRuntimeException(String id, int errorCode, String message, Throwable cause) {
        this(id, errorCode, new Throwable(message, cause));
    }

    public CoreRuntimeException(String id, int errorCode, String message) {
        this(id, errorCode, new Throwable(message));
    }

    public CoreRuntimeException(String id, int errorCode, Throwable cause) {
        this(id, cause);
        this.errorCode = errorCode;
    }

    public CoreRuntimeException(String id, Throwable cause) {
        this(cause);
        this.id = id;
    }

    public CoreRuntimeException(Throwable cause) {
        super(cause != null && cause.getMessage() == null && !Throwable.class.getName().equals(cause.getClass().getName()) ? cause.toString() : (cause == null ? null : cause.getMessage()), cause);
        if (cause instanceof CoreRuntimeException) {
            this.errorCode = ((CoreRuntimeException)cause).getErrorCode();
        }
    }

    public CoreRuntimeException(String id, SQLException cause) {
        this(cause);
        this.id = id;
    }

    public CoreRuntimeException(SQLException cause) {
        super(cause.getMessage(), cause);
        switch (cause.getErrorCode()) {
            case 100: {
                this.errorCode = 100;
                break;
            }
            default: {
                this.errorCode = -cause.getErrorCode();
            }
        }
    }

    public boolean is(Class<? extends CoreRuntimeException> exceptionClass) {
        return this.getClass().equals(exceptionClass);
    }

    public boolean equalsByCode(CoreRuntimeException e) {
        return this.equalsTo(e.errorCode);
    }

    public boolean equalsTo(int errorCode) {
        return this.errorCode != 1 && this.errorCode == errorCode;
    }

    public boolean equalsTo(String id) {
        if (this.id == null) {
            return false;
        }
        return this.id.equals(id);
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

