/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.runtime.util;

import java.util.Collection;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import ru.cft.platform.core.runtime.service.SettingService;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class ServiceUtils {
    private static final ILogger LOGGER = Logger.getLogger(ServiceUtils.class);
    private static final SettingService settingService = ServiceUtils.lookup(SettingService.class, null, false);

    public static <T> T lookup(Class<T> service) throws ServiceConfigurationError {
        return ServiceUtils.lookup(service, null, true);
    }

    public static <T> T lookup(Class<T> service, Predicate<T> filter, boolean notNull) throws ServiceConfigurationError {
        T result = null;
        if (service == null) {
            throw new IllegalArgumentException("Service class is null");
        }
        String className = null;
        try {
            if (settingService != null) {
                className = settingService.getContainerSetting(service.getCanonicalName());
            }
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), t);
        }
        if (className != null) {
            try {
                result = service.cast(Class.forName(className).newInstance());
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Unable to load " + service.getCanonicalName() + ", please check that it is included in your distribution.");
            }
        } else {
            ServiceLoader<T> services = ServiceLoader.load(service, service.getClassLoader());
            for (T t : services) {
                if (filter != null && !filter.test(t)) continue;
                if (result == null) {
                    result = t;
                    continue;
                }
                throw new ServiceConfigurationError("More than one " + service.getCanonicalName() + " found");
            }
        }
        if (result == null && notNull) {
            throw new ServiceConfigurationError("No one " + service.getCanonicalName() + " found");
        }
        return result;
    }

    public static <S extends Predicate<T>, T> void invoke(Collection<S> services, T testObj, Consumer<S> job) {
        ServiceUtils.invoke(services, testObj, job, true);
    }

    public static <S extends Predicate<T>, T> void invoke(Collection<S> services, T testObj, Consumer<S> job, boolean required) {
        for (Predicate service : services) {
            if (!service.test(testObj)) continue;
            job.accept(service);
            return;
        }
        if (required) {
            throw new ServiceConfigurationError("No one service found");
        }
    }

    public static <S extends Predicate<T>, T, R> R invokeFunction(Collection<S> services, T testObj, Function<S, R> job) {
        return ServiceUtils.invokeFunction(services, testObj, job, true);
    }

    public static <S extends Predicate<T>, T, R> R invokeFunction(Collection<S> services, T testObj, Function<S, R> job, boolean required) {
        for (Predicate service : services) {
            if (!service.test(testObj)) continue;
            return job.apply(service);
        }
        if (required) {
            throw new ServiceConfigurationError("No one service found");
        }
        return null;
    }
}

