/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.metamodel.cache.export;

import java.io.File;
import java.util.Collections;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import ru.cft.platform.core.metamodel.cache.serialize.MetaCacheSerializerImpl;

@Mojo(name="export-metamodel-cache", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ExportMetamodelCache
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/METAMODEL")
    private String inputDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/WEB-INF/lib")
    private String outputDirectory;
    @Parameter(defaultValue="metamodel.gz")
    private String cacheFilename;
    @Parameter(defaultValue="${project.artifactId}")
    private String scheme;
    @Parameter(defaultValue="127.0.0.1")
    private String igniteHost;
    @Parameter(defaultValue="65482")
    private String ignitePort;
    @Parameter(defaultValue="CORE-METAMODEL-NODE")
    private String igniteInstanceName;
    @Parameter(property="skipExportMetamodelCache", defaultValue="false")
    private Boolean skipExportMetamodelCache;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"========== export-metamodel-cache =========");
        if (this.skipExportMetamodelCache != null && this.skipExportMetamodelCache.booleanValue()) {
            this.getLog().info((CharSequence)"Skip export-metamodel-cache goal");
            this.getLog().info((CharSequence)("inputDirectory:" + this.inputDirectory.toString()));
            this.copyFile(this.inputDirectory, this.outputDirectory, this.cacheFilename);
            return;
        }
        this.getLog().info((CharSequence)("scheme: " + this.scheme));
        this.getLog().info((CharSequence)("igniteHost: " + this.igniteHost));
        this.getLog().info((CharSequence)("ignitePort : " + this.ignitePort));
        this.getLog().info((CharSequence)("igniteInstanceName : " + this.igniteInstanceName));
        this.getLog().info((CharSequence)("outputDirectory : " + this.outputDirectory));
        this.getLog().info((CharSequence)("cacheFilename : " + this.cacheFilename));
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setClientMode(true);
        cfg.setIgniteInstanceName(this.igniteInstanceName);
        TcpDiscoveryMulticastIpFinder ipFinder = new TcpDiscoveryMulticastIpFinder();
        ipFinder.setAddresses(Collections.singletonList(this.igniteHost + ":" + this.ignitePort));
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)ipFinder));
        try (Ignite ignite = Ignition.getOrStart((IgniteConfiguration)cfg);){
            this.getLog().info((CharSequence)"Start serializing metamodel cache...");
            File outputFile = this.getOutpuFile(this.outputDirectory, this.cacheFilename);
            new MetaCacheSerializerImpl(ignite).serialize(this.scheme, outputFile.getAbsolutePath());
            this.getLog().info((CharSequence)"Serializing metamodel cache complete");
        }
    }

    private File getOutpuFile(String outputDirectory, String cacheFilename) {
        File outputFile = new File(outputDirectory);
        outputFile.mkdirs();
        outputFile = new File(outputFile, cacheFilename);
        return outputFile;
    }

    private void copyFile(String srcDirectory, String outputDirectory, String cacheFilename) {
        File inputPath = new File(srcDirectory);
        if (!inputPath.exists()) {
            this.getLog().info((CharSequence)(inputPath + " do not exists"));
            return;
        }
        File inputFile = new File(inputPath, cacheFilename);
        if (!inputFile.exists()) {
            this.getLog().info((CharSequence)(inputFile + " do not exists"));
            return;
        }
        File outputFile = this.getOutpuFile(outputDirectory, cacheFilename);
        try {
            if (inputFile.renameTo(new File(outputFile.getAbsolutePath()))) {
                outputFile.setLastModified(System.currentTimeMillis());
                this.getLog().info((CharSequence)("Copy " + inputFile + " to " + outputFile));
                inputPath.delete();
            } else {
                this.getLog().info((CharSequence)("Do not copy " + inputFile + " to " + outputFile));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error:" + e.getMessage()));
        }
    }

    public static void main(String[] args) throws MojoExecutionException, MojoFailureException {
        ExportMetamodelCache exporter = new ExportMetamodelCache();
        exporter.scheme = "DBI_UseCase";
        exporter.igniteHost = "127.0.0.1";
        exporter.ignitePort = "65482";
        exporter.igniteInstanceName = "CORE-METAMODEL-NODE";
        exporter.cacheFilename = "mmm.gz";
        exporter.outputDirectory = "C:\\WS\\workspace_IDE\\dbi_usecase\\DBI_UseCase\\target/ibso/WEB-INF/lib";
        exporter.execute();
    }
}

