/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import ru.cft.platform.configuration.Configurator;
import ru.cft.platform.jaas.IJAASConfiguration;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class JAASConfiguration
extends Configuration
implements IJAASConfiguration {
    private static final ILogger LOGGER = Logger.getLogger(JAASConfiguration.class);
    private static final String JAAS_SETTINGS_FILE_NAME = "jaas-settings.xml";
    private static final String MODULE_CLASS_PROPERTY_NAME = "login-module-class";
    private static final String NTLM_LOGIN_MODULE_CLASS_NAME = "ru.cft.platform.jaas.ntlm.NTLMLoginModule";
    private static final String NTLM_PROTOCOL_LOGIN_MODULE_CLASS_NAME = "ru.cft.platform.jaas.ntlm.NTLMProtocolLoginModule";
    private static final String AUTO_LOGON_POSTFIX = "-AutoLogon";
    private static final int MAX_RANDOM = 0x40000000;
    private static JAASConfiguration INSTANCE;
    private Map<String, AppConfigurationEntry[]> config;
    private Map<String, String> autoLogonJAASConfigNames;
    private Configuration systemConf;

    JAASConfiguration() {
    }

    static synchronized JAASConfiguration getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("JAASConfiguration not initialized!");
        }
        return INSTANCE;
    }

    public static synchronized IJAASConfiguration get() {
        return JAASConfiguration.getInstance();
    }

    synchronized void initialize() {
        if (INSTANCE != null) {
            return;
        }
        this.config = new HashMap<String, AppConfigurationEntry[]>();
        this.autoLogonJAASConfigNames = new HashMap<String, String>();
        Configuration c = null;
        try {
            c = Configuration.getConfiguration();
        }
        catch (Exception ignore) {
            LOGGER.debug("System JAAS configuration not found");
        }
        this.systemConf = c;
        this.initConfig();
        LOGGER.debug("try set system default configuration.");
        Configuration.setConfiguration(this);
        INSTANCE = this;
    }

    synchronized void deinitialize() {
        INSTANCE = null;
        if (this.systemConf != null) {
            Configuration.setConfiguration(this.systemConf);
        }
        this.systemConf = null;
        this.autoLogonJAASConfigNames = null;
        this.config = null;
    }

    private void initConfig() {
        LOGGER.debug("try init Core JAAS configuration.");
        Properties props = Configurator.getPropertySettings((String)JAAS_SETTINGS_FILE_NAME);
        if (props != null) {
            HashMap<String, HashMap<String, String>> jaasTmpProps = new HashMap<String, HashMap<String, String>>();
            for (Object object : props.keySet()) {
                String key = (String)object;
                int a = key.indexOf(46);
                if (a < 0) {
                    throw new RuntimeException("Property " + key + " must be of the format <config name>.*");
                }
                String tag = key.substring(0, a);
                String name = key.substring(a + 1);
                HashMap<String, String> jaasProperties = (HashMap<String, String>)jaasTmpProps.get(tag);
                if (jaasProperties == null) {
                    jaasProperties = new HashMap<String, String>();
                    jaasTmpProps.put(tag, jaasProperties);
                }
                jaasProperties.put(name, props.getProperty(key));
            }
            HashMap<String, AppConfigurationEntry[]> autoLogonJAASConfigEntries = new HashMap<String, AppConfigurationEntry[]>();
            for (Map.Entry entry : jaasTmpProps.entrySet()) {
                String tag = (String)entry.getKey();
                Map jaasProperties = (Map)entry.getValue();
                String moduleClass = (String)jaasProperties.remove(MODULE_CLASS_PROPERTY_NAME);
                if (moduleClass == null) {
                    throw new RuntimeException("Property 'login-module-class' must be set for configuration '" + tag + "'.");
                }
                this.config.put(tag, JAASConfiguration.createEntries(moduleClass, jaasProperties));
                LOGGER.debug("Add JAAS configuration Name=[" + tag + "], LoginModule=[" + moduleClass + "]");
                if (!NTLM_LOGIN_MODULE_CLASS_NAME.equals(moduleClass)) continue;
                autoLogonJAASConfigEntries.put(tag, JAASConfiguration.createEntries(NTLM_PROTOCOL_LOGIN_MODULE_CLASS_NAME, jaasProperties));
            }
            Random random = new Random();
            for (Map.Entry entry : autoLogonJAASConfigEntries.entrySet()) {
                String autoLogonNamePattern;
                String name = (String)entry.getKey();
                String autoLogonName = autoLogonNamePattern = name + AUTO_LOGON_POSTFIX;
                while (this.config.containsKey(autoLogonName)) {
                    autoLogonName = autoLogonNamePattern + "-" + Integer.toString(random.nextInt(0x40000000));
                }
                this.config.put(autoLogonName, (AppConfigurationEntry[])entry.getValue());
                this.autoLogonJAASConfigNames.put(name, autoLogonName);
            }
        } else {
            LOGGER.error("JAAS configuration properties not found in jaas-settings.xml file.");
        }
    }

    private static AppConfigurationEntry[] createEntries(String moduleClass, Map<String, String> jaasProperties) {
        return new AppConfigurationEntry[]{new AppConfigurationEntry(moduleClass, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, jaasProperties)};
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries = this.config.get(name);
        if (entries != null) {
            LOGGER.debug("Configuration " + name + " found.");
            return entries;
        }
        LOGGER.debug("Configuration " + name + " not found. try call to system configuration.");
        return this.systemConf == null ? null : this.systemConf.getAppConfigurationEntry(name);
    }

    @Override
    public List<String> createAutoLogonJAASConfigNameList(List<String> jaasConfigNameList) {
        ArrayList<String> autoLogonJAASConfigNameList = new ArrayList<String>();
        for (String name : jaasConfigNameList) {
            String autoLogonName = this.autoLogonJAASConfigNames.get(name);
            if (autoLogonName == null) continue;
            autoLogonJAASConfigNameList.add(autoLogonName);
        }
        return autoLogonJAASConfigNameList;
    }
}

