/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.ucp.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.jdbc.ValidConnection;
import ru.cft.platform.core.dao.datasource.impl.DataSourceConnection;
import ru.cft.platform.core.dao.datasource.impl.xa.XATransactionManager;
import ru.cft.platform.core.dao.datasource.ucp.AbstractUCPDataSource;

public class UCPXADataSource
extends AbstractUCPDataSource<PoolXADataSourceImpl> {
    public UCPXADataSource() {
        super(new PoolXADataSourceImpl(), PoolXADataSourceImpl.class);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = XATransactionManager.get().getConnection((DataSource)((Object)this));
        if (conn == null) {
            final XAConnection xaconn = ((PoolXADataSourceImpl)this.inner).getXAConnection(new Properties());
            try {
                conn = XATransactionManager.get().registerConnection((DataSource)((Object)this), new XAConnection(){

                    @Override
                    public void removeStatementEventListener(StatementEventListener listener) {
                        xaconn.removeStatementEventListener(listener);
                    }

                    @Override
                    public void removeConnectionEventListener(ConnectionEventListener listener) {
                        xaconn.removeConnectionEventListener(listener);
                    }

                    @Override
                    public Connection getConnection() throws SQLException {
                        return UCPXADataSource.this.wrapConnection(xaconn);
                    }

                    @Override
                    public void close() throws SQLException {
                        xaconn.close();
                    }

                    @Override
                    public void addStatementEventListener(StatementEventListener listener) {
                        xaconn.addStatementEventListener(listener);
                    }

                    @Override
                    public void addConnectionEventListener(ConnectionEventListener listener) {
                        xaconn.addConnectionEventListener(listener);
                    }

                    @Override
                    public XAResource getXAResource() throws SQLException {
                        return xaconn.getXAResource();
                    }
                });
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private Connection wrapConnection(final XAConnection xaconn) throws SQLException {
        return new DataSourceConnection(xaconn.getConnection()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void kill() throws SQLException {
                super.kill();
                XAConnection xAConnection = xaconn;
                synchronized (xAConnection) {
                    try {
                        ((ValidConnection)xaconn).setInvalid();
                    }
                    finally {
                        this.inner.close();
                        xaconn.close();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Savepoint setSavepoint(final String name) throws SQLException {
                Statement stmt = null;
                try {
                    stmt = this.createStatement();
                    stmt.execute("SAVEPOINT ".concat(name));
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                return new Savepoint(){

                    @Override
                    public String getSavepointName() throws SQLException {
                        return name;
                    }

                    @Override
                    public int getSavepointId() throws SQLException {
                        return name.hashCode();
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rollback(Savepoint savepoint) throws SQLException {
                Statement stmt = null;
                try {
                    stmt = this.createStatement();
                    stmt.execute("ROLLBACK TO SAVEPOINT ".concat(savepoint.getSavepointName()));
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        };
    }
}

