/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.ucp;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.UCPTaskManagerImpl;
import ru.cft.platform.core.dao.datasource.AbstractDataSourceLookup;
import ru.cft.platform.core.dao.datasource.DataSourceLookupListener;
import ru.cft.platform.core.dao.datasource.PoolDataSourceFacade;
import ru.cft.platform.core.dao.datasource.ucp.xa.UCPDataSource;
import ru.cft.platform.core.dao.event.ContainerShutdownEvent;
import ru.cft.platform.core.dao.event.ContainerShutdownEventListener;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class UCPDataSourceLookup
extends AbstractDataSourceLookup<ru.cft.platform.core.dao.datasource.ucp.UCPDataSource>
implements ObjectFactory,
ContainerShutdownEventListener {
    private static final ILogger LOGGER = Logger.getLogger(UCPDataSourceLookup.class);

    protected ru.cft.platform.core.dao.datasource.ucp.UCPDataSource createPool(String tag, Properties poolProperties) throws Exception {
        String className = poolProperties.getProperty("data-source-class-name");
        ru.cft.platform.core.dao.datasource.ucp.UCPDataSource ucpds = UCPDataSourceLookup.createDataSource(className);
        this.configurePool(ucpds, poolProperties);
        UniversalConnectionPoolManager pMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
        pMgr.createConnectionPool((UniversalConnectionPoolAdapter)ucpds);
        pMgr.startConnectionPool(ucpds.getAlias());
        try {
            UniversalConnectionPoolManagerMBean pMgrMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
            pMgrMBean.registerUniversalConnectionPoolMBean((UniversalConnectionPoolMBean)new JDBCUniversalConnectionPoolMBeanImpl(pMgr.getConnectionPool(ucpds.getAlias())));
        }
        catch (Exception e) {
            LOGGER.warn("Error while register pool in JMX", (Throwable)e);
        }
        return ucpds;
    }

    private static ru.cft.platform.core.dao.datasource.ucp.UCPDataSource createDataSource(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (className == null) {
            className = UCPDataSource.class.getName();
        }
        ru.cft.platform.core.dao.datasource.ucp.UCPDataSource ucpds = (ru.cft.platform.core.dao.datasource.ucp.UCPDataSource)Class.forName(className).newInstance();
        return ucpds;
    }

    protected void configurePool(ru.cft.platform.core.dao.datasource.ucp.UCPDataSource pool, Properties poolProperties) throws Exception {
        super.configurePool((PoolDataSourceFacade)pool, poolProperties);
        UCPDataSourceLookup.setProperty((Properties)poolProperties, (String)"time-to-live-connection-timeout", null, pool::setTimeToLiveTimeout, Integer::parseInt);
        UCPDataSourceLookup.setProperty((Properties)poolProperties, (String)"abandoned-connection-timeout", null, pool::setAbandonedConnectionTimeout, Integer::parseInt);
        UCPDataSourceLookup.setProperty((Properties)poolProperties, (String)"connection-wait-timeout", (Object)0, pool::setConnectionWaitTimeout, Integer::parseInt);
        UCPDataSourceLookup.setProperty((Properties)poolProperties, (String)"validate-connection-on-borrow", null, pool::setValidateConnectionOnBorrow, Boolean::parseBoolean);
        UCPDataSourceLookup.setProperty((Properties)poolProperties, (String)"validate-connection-sql", null, pool::setSQLForValidateConnection, String::toString);
        UCPDataSourceLookup.setProperty((Properties)poolProperties, (String)"invalidate-connection-in-ttl-callback", (Object)true, pool::setInvalidateInTTL, Boolean::parseBoolean);
        for (DataSourceLookupListener listener : ServiceLoader.load(DataSourceLookupListener.class)) {
            listener.configureDataSource((DataSource)pool.getPoolDataSource(), poolProperties);
        }
    }

    public void onContainerShutdown(ContainerShutdownEvent event) {
        try {
            UniversalConnectionPoolManager pMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
            TaskManager taskManager = UniversalConnectionPoolManagerImpl.getTaskManager();
            ExecutorService ucpThreadPool = null;
            if (taskManager instanceof UCPTaskManagerImpl) {
                ucpThreadPool = ((UCPTaskManagerImpl)taskManager).getUCPThreadPool();
            }
            List<String> connectionPoolNames = Arrays.asList(pMgr.getConnectionPoolNames());
            for (String alias : dsMap.keySet()) {
                if (!connectionPoolNames.contains(alias)) continue;
                pMgr.stopConnectionPool(alias);
                pMgr.destroyConnectionPool(alias);
            }
            UniversalConnectionPoolManagerImpl.getTaskManager().stop();
            UniversalConnectionPoolManagerImpl.getTimerManager().stop();
            if (ucpThreadPool != null) {
                try {
                    ucpThreadPool.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (UniversalConnectionPoolException e) {
            LOGGER.error("Unable to stop and destroy pool on ContainerShutdownEvent", (Throwable)e);
        }
    }

    protected String getPropertiesPrefix() {
        return "ucp";
    }
}

