/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.ucp;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.ValidConnection;
import ru.cft.platform.core.dao.datasource.PoolDataSourceFacade;
import ru.cft.platform.core.dao.datasource.impl.DataSourceConnection;
import ru.cft.platform.core.dao.datasource.ucp.UCPDataSourceLookup;
import ru.cft.platform.core.dao.sql.AbstractDataSourceWrapper;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public abstract class AbstractUCPDataSource<DS extends PoolDataSourceImpl>
extends AbstractDataSourceWrapper<DS>
implements PoolDataSourceFacade,
UniversalConnectionPoolAdapter,
Referenceable {
    private static final ILogger logger = Logger.getLogger(AbstractUCPDataSource.class);
    private static Properties lebel = new Properties();
    private boolean labelingCallbackEnabled;
    private boolean invalidateInTTL;

    protected AbstractUCPDataSource(DS inner, Class<DS> iface) {
        super(inner, iface);
        if (logger.isTraceEnabled()) {
            try {
                UniversalConnectionPoolManager pMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                pMgr.setLogLevel(Level.FINEST);
            }
            catch (UniversalConnectionPoolException e) {
                logger.error((Object)e);
            }
        }
    }

    public PoolDataSource getPoolDataSource() {
        return (PoolDataSource)this.inner;
    }

    void setLabelingCallbackEnabled(boolean value) {
        this.labelingCallbackEnabled = value;
    }

    void setInvalidateInTTL(boolean value) {
        this.invalidateInTTL = value;
    }

    private Connection getWrapConnection(Connection conn) throws SQLException {
        if (this.invalidateInTTL) {
            ((ConnectionWithTimeToLiveTimeout)conn).removeTimeToLiveConnectionTimeoutCallback();
            ((ConnectionWithTimeToLiveTimeout)conn).registerTimeToLiveConnectionTimeoutCallback((TimeToLiveConnectionTimeoutCallback)new TTLCallback(conn));
            if (logger.isDebugEnabled()) {
                logger.debug(((PoolDataSourceImpl)this.inner).getConnectionPoolName() + "#TTLCallback#" + conn.toString() + " register Callback.");
            }
        }
        return this.wrapConnection(conn);
    }

    public Connection getConnection() throws SQLException {
        Connection conn = null;
        try {
            conn = this.labelingCallbackEnabled ? ((PoolDataSourceImpl)this.inner).getConnection(lebel) : ((PoolDataSourceImpl)this.inner).getConnection();
            conn = this.getWrapConnection(conn);
        }
        catch (SQLException eSQL) {
            if (conn != null && !((ValidConnection)conn).isValid()) {
                try {
                    UniversalConnectionPoolManager pMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                    pMgr.recycleConnectionPool(((PoolDataSourceImpl)this.inner).getConnectionPoolName());
                    conn.close();
                    conn = this.labelingCallbackEnabled ? ((PoolDataSourceImpl)this.inner).getConnection(lebel) : ((PoolDataSourceImpl)this.inner).getConnection();
                    conn = this.getWrapConnection(conn);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error getting connection.", e);
                }
            }
            throw eSQL;
        }
        return conn;
    }

    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = null;
        try {
            conn = this.labelingCallbackEnabled ? ((PoolDataSourceImpl)this.inner).getConnection(username, password, lebel) : ((PoolDataSourceImpl)this.inner).getConnection(username, password);
            conn = this.getWrapConnection(conn);
        }
        catch (SQLException eSQL) {
            if (conn != null && !((ValidConnection)conn).isValid()) {
                try {
                    UniversalConnectionPoolManager pMgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                    pMgr.recycleConnectionPool(((PoolDataSourceImpl)this.inner).getConnectionPoolName());
                    conn.close();
                    conn = this.labelingCallbackEnabled ? ((PoolDataSourceImpl)this.inner).getConnection(username, password, lebel) : ((PoolDataSourceImpl)this.inner).getConnection(username, password);
                    conn = this.getWrapConnection(conn);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error getting connection.", e);
                }
            }
            throw eSQL;
        }
        return conn;
    }

    public UniversalConnectionPool createUniversalConnectionPool() throws Exception {
        return ((PoolDataSourceImpl)this.inner).createUniversalConnectionPool();
    }

    public UniversalConnectionPoolMBean createUniversalConnectionPoolMBean() throws Exception {
        return ((PoolDataSourceImpl)this.inner).createUniversalConnectionPoolMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logConnection(Connection conn, String prefix) {
        Statement cs = null;
        try {
            if (conn == null || conn.isClosed()) {
                return;
            }
            cs = conn.prepareCall("begin ? := USERENV('sessionid'); end;");
            cs.registerOutParameter(1, 2);
            cs.executeUpdate();
            logger.debug("Connection SID " + prefix + " : " + cs.getInt(1));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (cs != null) {
                    cs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private Connection wrapConnection(final Connection conn) throws SQLException {
        if (logger.isDebugEnabled()) {
            AbstractUCPDataSource.logConnection(conn, "get");
        }
        return new DataSourceConnection(conn){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void kill() throws SQLException {
                super.kill();
                Connection connection = this.inner;
                synchronized (connection) {
                    try {
                        ((ValidConnection)this.inner).setInvalid();
                    }
                    finally {
                        this.inner.close();
                    }
                }
            }

            public void close() throws SQLException {
                if (logger.isDebugEnabled()) {
                    AbstractUCPDataSource.logConnection(conn, "put");
                }
                if (this.inner == null || this.inner.isClosed()) {
                    logger.debug("Connection is already closed!");
                } else {
                    this.inner.close();
                }
            }
        };
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), UCPDataSourceLookup.class.getName(), null);
        ref.add(new StringRefAddr("alias", this.getPoolDataSource().getConnectionPoolName()));
        return ref;
    }

    public void setConnectionFactoryClassName(String className) {
        try {
            ((PoolDataSourceImpl)this.inner).setConnectionFactoryClassName(className);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAlias(String alias) {
        try {
            ((PoolDataSourceImpl)this.inner).setConnectionPoolName(alias);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAlias() {
        return ((PoolDataSourceImpl)this.inner).getConnectionPoolName();
    }

    public void setUser(String user) {
        try {
            ((PoolDataSourceImpl)this.inner).setUser(user);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPassword(String password) {
        try {
            ((PoolDataSourceImpl)this.inner).setPassword(password);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setURL(String url) {
        try {
            ((PoolDataSourceImpl)this.inner).setURL(url);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInitialPoolSize(int size) {
        try {
            ((PoolDataSourceImpl)this.inner).setInitialPoolSize(size);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMinPoolSize(int size) {
        try {
            ((PoolDataSourceImpl)this.inner).setMinPoolSize(size);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMaxPoolSize(int size) {
        try {
            ((PoolDataSourceImpl)this.inner).setMaxPoolSize(size);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setInactiveConnectionTimeout(int timeout) {
        try {
            ((PoolDataSourceImpl)this.inner).setInactiveConnectionTimeout(timeout);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTimeoutCheckInterval(int interval) {
        try {
            ((PoolDataSourceImpl)this.inner).setTimeoutCheckInterval(interval);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTimeToLiveTimeout(int timeout) {
        try {
            ((PoolDataSourceImpl)this.inner).setTimeToLiveConnectionTimeout(timeout);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAbandonedConnectionTimeout(int timeout) {
        try {
            ((PoolDataSourceImpl)this.inner).setAbandonedConnectionTimeout(timeout);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConnectionWaitTimeout(int timeout) {
        try {
            ((PoolDataSourceImpl)this.inner).setConnectionWaitTimeout(timeout);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValidateConnectionOnBorrow(boolean validate) {
        try {
            ((PoolDataSourceImpl)this.inner).setValidateConnectionOnBorrow(validate);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSQLForValidateConnection(String sql) {
        try {
            ((PoolDataSourceImpl)this.inner).setSQLForValidateConnection(sql);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private class TTLCallback
    implements TimeToLiveConnectionTimeoutCallback,
    Runnable {
        private final Connection conn;
        private boolean executed = false;
        private boolean finished = false;
        private String name;

        TTLCallback(Connection conn) {
            this.conn = conn;
        }

        private String getName() {
            return ((PoolDataSourceImpl)AbstractUCPDataSource.this.inner).getConnectionPoolName() + "#TTLCallback#" + this.conn.toString();
        }

        public boolean handleTimedOutConnection() {
            try {
                if (!this.conn.isClosed()) {
                    if (!this.finished) {
                        if (!this.executed) {
                            this.name = this.getName();
                            Thread th = new Thread(this);
                            th.setName(this.name + " invalidator");
                            th.start();
                            this.executed = true;
                        }
                        logger.warn(this.name + " invalidator in process, return true");
                        return true;
                    }
                    logger.warn(this.name + " invalidator finished, return false");
                }
            }
            catch (Exception ee) {
                logger.warn(this.getName() + " exception.", (Throwable)ee);
            }
            return false;
        }

        @Override
        public void run() {
            try {
                logger.warn(this.name + " try set connection invalid.");
                if (!this.conn.isClosed()) {
                    ((ValidConnection)this.conn).setInvalid();
                    logger.warn(this.name + " connection status is " + (((ValidConnection)this.conn).isValid() ? "" : "in") + "valid.");
                } else {
                    logger.warn(this.name + " connection is closed!");
                }
            }
            catch (Exception ee) {
                logger.warn(this.name + " set connection invalid exception.", (Throwable)ee);
            }
            finally {
                this.finished = true;
            }
        }
    }
}

