/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.tomcat;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.XAConnection;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import ru.cft.platform.core.dao.datasource.PoolDataSourceFacade;
import ru.cft.platform.core.dao.datasource.impl.DataSourceConnection;
import ru.cft.platform.core.dao.datasource.impl.xa.XAConnectionEmulation;
import ru.cft.platform.core.dao.datasource.impl.xa.XATransactionManager;
import ru.cft.platform.core.dao.datasource.tomcat.TomcatPoolDataSourceLookup;
import ru.cft.platform.core.dao.sql.AbstractDataSourceWrapper;

public class TomcatPoolDataSource
extends AbstractDataSourceWrapper<DataSource>
implements PoolDataSourceFacade,
Referenceable {
    public TomcatPoolDataSource() {
        super((javax.sql.DataSource)new DataSource(), DataSource.class);
    }

    DataSource getPoolDataSource() {
        return (DataSource)this.inner;
    }

    public Connection getConnection() throws SQLException {
        Connection conn = XATransactionManager.get().getConnection((javax.sql.DataSource)((Object)this));
        if (conn == null && !(conn = super.getConnection()).isReadOnly()) {
            XAConnectionEmulation xaconn = new XAConnectionEmulation(conn);
            try {
                conn = XATransactionManager.get().registerConnection((javax.sql.DataSource)((Object)this), (XAConnection)xaconn);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return this.wrapConnection(conn);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private Connection wrapConnection(Connection conn) throws SQLException {
        return new DataSourceConnection(conn){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void kill() throws SQLException {
                Connection connection = this.inner;
                synchronized (connection) {
                    this.inner.unwrap(PooledConnection.class).setDiscarded(true);
                    this.inner.close();
                }
            }
        };
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), TomcatPoolDataSourceLookup.class.getName(), null);
        ref.add(new StringRefAddr("alias", ((DataSource)this.inner).getName()));
        return ref;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    public void setConnectionFactoryClassName(String className) {
        ((DataSource)this.inner).setDriverClassName(className);
    }

    public void setAlias(String alias) {
        ((DataSource)this.inner).setName(alias);
    }

    public String getAlias() {
        return ((DataSource)this.inner).getName();
    }

    public void setUser(String user) {
        ((DataSource)this.inner).setUsername(user);
    }

    public void setPassword(String password) {
        ((DataSource)this.inner).setPassword(password);
    }

    public void setURL(String url) {
        ((DataSource)this.inner).setUrl(url);
    }

    public void setInitialPoolSize(int size) {
        ((DataSource)this.inner).setInitialSize(size);
    }

    public void setMinPoolSize(int size) {
        ((DataSource)this.inner).setMinIdle(size);
    }

    public void setMaxPoolSize(int size) {
        ((DataSource)this.inner).setMaxActive(size);
        ((DataSource)this.inner).setMaxIdle(size);
        ((DataSource)this.inner).setMaxActive(size);
    }

    public void setInactiveConnectionTimeout(int timeout) {
        ((DataSource)this.inner).setMinEvictableIdleTimeMillis((int)TimeUnit.SECONDS.toMillis(timeout));
    }

    public void setTimeoutCheckInterval(int interval) {
        ((DataSource)this.inner).setValidationInterval((long)((int)TimeUnit.SECONDS.toMillis(interval)));
    }
}

