/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.tomcat;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import ru.cft.platform.core.dao.datasource.AbstractDataSourceLookup;
import ru.cft.platform.core.dao.datasource.PoolDataSourceFacade;
import ru.cft.platform.core.dao.datasource.tomcat.TomcatPoolDataSource;
import ru.cft.platform.core.dao.event.ContainerShutdownEvent;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class TomcatPoolDataSourceLookup
extends AbstractDataSourceLookup<TomcatPoolDataSource> {
    private static final ILogger LOGGER = Logger.getLogger(TomcatPoolDataSourceLookup.class);

    protected void configurePool(TomcatPoolDataSource pool, Properties poolProperties) throws Exception {
        super.configurePool((PoolDataSourceFacade)pool, poolProperties);
        DataSource pds = pool.getPoolDataSource();
        TomcatPoolDataSourceLookup.setProperty((Properties)poolProperties, (String)"default-read-only", null, arg_0 -> ((DataSource)pds).setDefaultReadOnly(arg_0), Boolean::parseBoolean);
    }

    public void onContainerShutdown(ContainerShutdownEvent event) {
        for (javax.sql.DataSource pds : dsMap.values()) {
            try {
                TomcatPoolDataSource tpds = pds.unwrap(TomcatPoolDataSource.class);
                if (tpds == null) continue;
                tpds.getPoolDataSource().close();
            }
            catch (SQLException e) {
                LOGGER.error("Unable to stop and destroy pool on ContainerShutdownEvent", (Throwable)e);
            }
        }
    }

    protected TomcatPoolDataSource createPool(String tag, Properties poolProperties) throws Exception {
        TomcatPoolDataSource tomcatPoolDataSource = new TomcatPoolDataSource();
        this.configurePool(tomcatPoolDataSource, poolProperties);
        return tomcatPoolDataSource;
    }

    protected String getPropertiesPrefix() {
        return "tomcat";
    }
}

