/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.impl.xa;

import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import ru.cft.platform.core.dao.datasource.DataSourceLookup;
import ru.cft.platform.core.dao.datasource.impl.DataSourceMap;
import ru.cft.platform.core.dao.datasource.impl.ObjectNotFoundException;
import ru.cft.platform.core.dao.datasource.impl.xa.JNDIDataSource;

public class JNDIDataSourceLookup
implements DataSourceLookup {
    private static Map<String, DataSource> dsMap = new DataSourceMap();
    private static InitialContext context = null;

    public DataSource getDataSource(String alias) throws ObjectNotFoundException {
        if (!dsMap.containsKey(alias)) {
            JNDIDataSourceLookup.lookupDataSource(alias);
        }
        return dsMap.get(alias);
    }

    private static synchronized void lookupDataSource(String alias) {
        if (!dsMap.containsKey(alias)) {
            try {
                if (context == null) {
                    context = new InitialContext();
                }
                DataSource ds = (DataSource)context.lookup(alias);
                dsMap.put(alias, new JNDIDataSource(ds));
            }
            catch (Exception e) {
                throw new ObjectNotFoundException("Error initializing JNDI connection pool", e);
            }
        }
    }
}

