/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.core.dao.datasource.impl.xa;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import ru.cft.platform.core.dao.datasource.impl.DataSourceConnection;
import ru.cft.platform.core.dao.datasource.impl.xa.XAConnectionEmulation;
import ru.cft.platform.core.dao.datasource.impl.xa.XATransactionManager;
import ru.cft.platform.logging.ILogger;

public class JNDIDataSource
implements DataSource {
    private static ILogger LOG = ru.cft.platform.logging.Logger.getLogger(JNDIDataSource.class);
    private DataSource dataSource = null;

    public JNDIDataSource(DataSource source) {
        this.dataSource = source;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(JNDIDataSource.class)) {
            return iface.cast(this);
        }
        if (iface.equals(Connection.class)) {
            return iface.cast(this.dataSource);
        }
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.equals(JNDIDataSource.class)) {
            return true;
        }
        if (iface.equals(Connection.class)) {
            return true;
        }
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LOG.trace("getConnection");
        Connection conn = XATransactionManager.get().getConnection((DataSource)this);
        if (conn == null) {
            XAConnectionEmulation xaconn = new XAConnectionEmulation(this.dataSource.getConnection());
            try {
                conn = XATransactionManager.get().registerConnection((DataSource)this, (XAConnection)xaconn);
                LOG.trace("Connection " + conn.hashCode() + " was obtained from DataSource");
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            LOG.trace("Connection " + conn.hashCode() + " was obtained from XATransactionManager");
        }
        return this.wrapConnection(conn);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        LOG.trace("getConnection(username, password)");
        Connection conn = XATransactionManager.get().getConnection((DataSource)this);
        if (conn == null) {
            XAConnectionEmulation xaconn = new XAConnectionEmulation(this.dataSource.getConnection(username, password));
            try {
                conn = XATransactionManager.get().registerConnection((DataSource)this, (XAConnection)xaconn);
                LOG.trace("Connection " + conn.hashCode() + " was obtained from DataSource");
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        } else {
            LOG.trace("Connection " + conn.hashCode() + " was obtained from XATransactionManager");
        }
        return this.wrapConnection(conn);
    }

    private Connection wrapConnection(Connection conn) throws SQLException {
        return new DataSourceConnection(conn){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void kill() throws SQLException {
                super.kill();
                Connection connection = this.inner;
                synchronized (connection) {
                    LOG.trace("Killing connection " + this.inner.hashCode());
                    JNDIDataSource.this.tryMarkBadConnectionForPool("oracle.ucp.jdbc.ValidConnection", "setInvalid", this.inner);
                    JNDIDataSource.this.tryMarkBadConnectionForPool("weblogic.jdbc.extensions.WLConnection", "setFailed", this.inner);
                    this.inner.close();
                }
            }
        };
    }

    private void tryMarkBadConnectionForPool(String className, String methodName, Connection inner) {
        try {
            Class<?> weblogicWrapperClass = Class.forName(className);
            if (inner.isWrapperFor(weblogicWrapperClass)) {
                LOG.trace("Trying to remove " + weblogicWrapperClass.getCanonicalName() + " from pool");
                Object unwrapped = inner.unwrap(weblogicWrapperClass);
                Method setInvalidMethod = weblogicWrapperClass.getDeclaredMethod(methodName, new Class[0]);
                setInvalidMethod.invoke(unwrapped, new Object[0]);
                LOG.trace(methodName + " for connection " + weblogicWrapperClass.getCanonicalName() + " was successfully executed");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

