/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class Configurator {
    private static final ILogger LOGGER = Logger.getLogger(Configurator.class);
    private static Map<String, Properties> props = new HashMap<String, Properties>();
    private static HashMap<String, ResourceFile> resources = new HashMap();
    private static final String SYSTEM_PROPERTY_CONTAINER_SETTINGS_PREFIX = "ibso.container.";
    private static final String JNDI_CONTAINER_SETTINGS_PREFIX = "java:comp/env/ibsoContainer";

    public static Properties getPropertySettings(String settingsFileName) {
        if (settingsFileName == null || settingsFileName.isEmpty()) {
            return null;
        }
        Properties prp = props.get(settingsFileName);
        if (prp != null) {
            return prp;
        }
        Configurator.registerResource(settingsFileName);
        return Configurator.configurePropertySettings(settingsFileName);
    }

    public static URL getSettingsAsUrl(String settingsFileName) {
        URL url;
        if (settingsFileName == null || settingsFileName.isEmpty()) {
            return null;
        }
        URL uRL = url = resources.get(settingsFileName) == null ? null : resources.get(settingsFileName).getUrl();
        if (url != null) {
            return url;
        }
        Configurator.registerResource(settingsFileName);
        return resources.get(settingsFileName) == null ? null : resources.get(settingsFileName).getUrl();
    }

    public static File getSettingsAsFile(String settingsFileName) {
        File file;
        if (settingsFileName == null || settingsFileName.isEmpty()) {
            return null;
        }
        File file2 = file = resources.get(settingsFileName) == null ? null : resources.get(settingsFileName).getFile();
        if (file != null) {
            return file;
        }
        Configurator.registerResource(settingsFileName);
        return resources.get(settingsFileName) == null ? null : resources.get(settingsFileName).getFile();
    }

    public static void resetPropertySettings(String settingsFileName) {
        props.remove(settingsFileName);
        Configurator.getPropertySettings(settingsFileName);
    }

    private static void registerResource(String settingsFileName) {
        block17: {
            try {
                URL url;
                if (settingsFileName == null || settingsFileName.isEmpty()) {
                    return;
                }
                String name = settingsFileName;
                if (name.lastIndexOf(".") > 0) {
                    name = name.substring(0, name.lastIndexOf("."));
                }
                name = Configurator.toProperCase(name);
                String settingsFullFileName = System.getProperty(SYSTEM_PROPERTY_CONTAINER_SETTINGS_PREFIX + name.toLowerCase());
                if (settingsFullFileName == null) {
                    LOGGER.info("System property ibso.container." + name.toLowerCase() + " is undefined, looking for environment entry " + JNDI_CONTAINER_SETTINGS_PREFIX + name);
                    settingsFullFileName = Configurator.getSettingsFileNameViaJNDI(JNDI_CONTAINER_SETTINGS_PREFIX + name);
                    if (settingsFullFileName == null) {
                        LOGGER.info("Environment entry java:comp/env/ibsoContainer" + name + " is undefined, looking for " + settingsFileName + " file in current working directory");
                        File defaultPath = new File(settingsFileName);
                        settingsFullFileName = defaultPath.getAbsolutePath();
                    }
                }
                LOGGER.info("Try read settings from file: " + settingsFullFileName);
                File settingsFile = new File(settingsFullFileName);
                if (settingsFile.exists()) {
                    if (!settingsFile.canRead()) {
                        throw new RuntimeException("Settings file " + settingsFile.getAbsolutePath() + " is not readable");
                    }
                    resources.put(settingsFileName, new ResourceFile(settingsFile));
                    break block17;
                }
                File ff = null;
                for (ResourceFile f : resources.values()) {
                    if (f.getFile() != null) {
                        try {
                            File[] files = f.getFile().getParentFile().listFiles(new OnlyFile(settingsFileName));
                            if (files.length != 0) {
                                ff = files[0];
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Configurator error", (Throwable)e);
                        }
                    }
                    if (ff == null) continue;
                    LOGGER.info("Try read settings from file: " + ff.getAbsolutePath());
                    if (!ff.exists()) continue;
                    if (!ff.canRead()) {
                        throw new RuntimeException("Settings file " + ff.getAbsolutePath() + " is not readable");
                    }
                    resources.put(settingsFileName, new ResourceFile(ff));
                    break;
                }
                if (ff == null && (url = Configurator.getSettingsFileFromResources(settingsFileName)) != null) {
                    ff = new File(url.getFile().toString());
                    if (ff.exists() && ff.canRead()) {
                        resources.put(settingsFileName, new ResourceFile(ff));
                    } else {
                        resources.put(settingsFileName, new ResourceFile(url));
                    }
                }
            }
            catch (Exception e) {
                resources.remove(settingsFileName);
                throw new RuntimeException("Error reading settings", e);
            }
        }
    }

    private static Properties configurePropertySettings(String settingsFileName) {
        ResourceFile rFile = resources.get(settingsFileName);
        if (rFile == null) {
            throw new RuntimeException(new FileNotFoundException(settingsFileName));
        }
        LOGGER.info("Configure settings from file " + rFile.getPath());
        InputStream stream = null;
        try {
            stream = rFile.getInputStream();
            Properties properties = new Properties();
            properties.loadFromXML(stream);
            props.put(settingsFileName, properties);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            throw new RuntimeException("Configure settings from file " + rFile.getPath(), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getSettingsFileNameViaJNDI(String name) throws NamingException {
        try {
            InitialContext context = new InitialContext();
            return (String)context.lookup(name);
        }
        catch (NoInitialContextException context) {
        }
        catch (NameNotFoundException context) {
        }
        catch (Throwable e) {
            LOGGER.error("Configurator error", e);
        }
        return null;
    }

    private static String toProperCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    private static URL getSettingsFileFromResources(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = null;
        if (classLoader != null) {
            url = classLoader.getResource(stripped);
        }
        if (url == null) {
            url = Configurator.class.getResource(resource);
        }
        if (url == null) {
            url = Configurator.class.getClassLoader().getResource(stripped);
        }
        return url;
    }

    public static class OnlyFile
    implements FilenameFilter {
        String fileName;

        public OnlyFile(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase(this.fileName);
        }
    }

    private static class ResourceFile {
        private File file;
        private URL url;
        private boolean isresource;

        public ResourceFile(File file) {
            this.file = file;
            try {
                this.url = new URL(file.toURI().toString());
            }
            catch (MalformedURLException e) {
                LOGGER.error("Configurator error", (Throwable)e);
            }
            this.isresource = false;
        }

        public ResourceFile(URL url) {
            this.file = null;
            this.url = url;
            this.isresource = true;
        }

        public String getPath() {
            try {
                return this.isresource ? this.url.toURI().toString() : this.file.getAbsolutePath();
            }
            catch (URISyntaxException e) {
                LOGGER.error("Configurator error", (Throwable)e);
                return null;
            }
        }

        public File getFile() {
            return this.file;
        }

        public URL getUrl() {
            return this.url;
        }

        public InputStream getInputStream() throws Exception {
            return this.isresource ? this.url.openStream() : new FileInputStream(this.file);
        }
    }
}

