/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.jaas.certificate;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import ru.cft.platform.jaas.certificate.CertificatePrincipal;
import ru.cft.platform.logging.ILogger;
import ru.cft.platform.logging.Logger;

public class LoginModuleByCertificate
implements LoginModule {
    private static ILogger logger = Logger.getLogger(LoginModuleByCertificate.class);
    private CallbackHandler callbackHandler;
    protected Subject subject;
    protected String subjSN;
    protected String issuerDN;
    protected Properties properties = new Properties();
    protected boolean succeeded = false;
    protected boolean commitSucceeded = false;
    protected CertificatePrincipal principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        logger.debug("initialize");
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.subjSN = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.issuerDN = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.properties.put("OS_USER", this.subjSN);
            this.properties.put("OS_DOMAIN", this.issuerDN);
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            logger.error(uce.getMessage(), (Throwable)uce);
            throw new LoginException(uce.getMessage());
        }
        this.succeeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        logger.debug("commit: " + this.subjSN);
        if (!this.succeeded) {
            return false;
        }
        this.principal = new CertificatePrincipal(this.subjSN, this.issuerDN);
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        if (!this.subject.getPrivateCredentials().contains(this.properties)) {
            this.subject.getPrivateCredentials().add(this.properties);
        }
        logger.debug("commit(): put in subject properties.");
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            logger.debug("abort(): clean subject.");
            this.succeeded = false;
            this.cleanState();
            this.principal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        logger.debug("logout(): clean subject.");
        this.subject.getPrincipals().remove(this.principal);
        this.succeeded = false;
        this.commitSucceeded = false;
        this.cleanState();
        this.principal = null;
        return true;
    }

    protected void cleanState() {
        this.subjSN = null;
        this.issuerDN = null;
    }
}

