/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.cachemanager;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ru.cft.platform.cachemanager.Cache;

public class CacheManager {
    private static HashMap<Class<?>, Cache> globalCache = new HashMap();
    private static ReentrantReadWriteLock theLock = new ReentrantReadWriteLock();

    public static Cache<?, ?> getCache(Class<?> cl) {
        ReentrantReadWriteLock.ReadLock lock = theLock.readLock();
        lock.lock();
        try {
            if (globalCache.containsKey(cl)) {
                Cache cache = globalCache.get(cl);
                return cache;
            }
            Cache<?, ?> cache = null;
            return cache;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getCacheItem(Class<?> cl, K key) {
        ReentrantReadWriteLock.ReadLock lock = theLock.readLock();
        lock.lock();
        try {
            if (globalCache.containsKey(cl)) {
                Object v = globalCache.get(cl).get(key);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K1, V1> void putCacheItem(Class<?> cl, K1 key, V1 value) {
        ReentrantReadWriteLock.WriteLock lock = theLock.writeLock();
        lock.lock();
        try {
            if (!globalCache.containsKey(cl)) {
                globalCache.put(cl, new Cache());
            }
            globalCache.get(cl).put(key, value);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V removeCacheItem(Class<?> cl, K key) {
        ReentrantReadWriteLock.WriteLock lock = theLock.writeLock();
        lock.lock();
        try {
            if (globalCache.containsKey(cl)) {
                Object v = globalCache.get(cl).remove(key);
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K> boolean containsKeyCache(Class<?> cl, K key) {
        ReentrantReadWriteLock.ReadLock lock = theLock.readLock();
        lock.lock();
        try {
            if (globalCache.containsKey(cl)) {
                boolean bl = globalCache.get(cl).containsKey(key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static void clearCache(Class<?> cl) {
        ReentrantReadWriteLock.ReadLock lock = theLock.readLock();
        lock.lock();
        try {
            if (globalCache.containsKey(cl)) {
                globalCache.get(cl).clear();
            }
        }
        finally {
            lock.unlock();
        }
    }
}

