/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.hibernate.type.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.hibernate.internal.TypeLocatorImpl;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.UserType;
import ru.cft.platform.business.hibernate.type.NestedTableDescriptor;
import ru.cft.platform.hibernate.HibernateTypeService;

public class HibernateTypeServiceImpl
implements HibernateTypeService {
    private static Map<Class<?>, Class<? extends UserType>> nestedTableTypes = new HashMap();

    public Type getType(Class<?> type) {
        return new TypeLocatorImpl(new TypeResolver()).custom(this.getUserType(type));
    }

    private Class<? extends UserType> getUserType(Class<?> type) {
        Class<? extends UserType> result = nestedTableTypes.get(type);
        if (result == null) {
            throw new IllegalArgumentException("Can't find descriptor for " + type.getName());
        }
        return result;
    }

    static {
        ServiceLoader.load(NestedTableDescriptor.class).forEach(d -> nestedTableTypes.put(d.returnedClass(), d.getClass()));
    }
}

