/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.business.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;
import ru.cft.platform.business.runtime.type.NestedTable;
import ru.cft.platform.business.runtime.type.NestedTableService;

public abstract class NestedTableDescriptor<J extends NestedTable<?, ?>>
implements UserType<J> {
    private static final Collection<NestedTableService> services = new ArrayList<NestedTableService>();

    protected abstract NestedTable<?, ?> newNestedTable();

    public J assemble(Serializable cached, Object owner) {
        return (J)((NestedTable)this.returnedClass().cast(cached));
    }

    public Serializable disassemble(J value) {
        return value;
    }

    public J deepCopy(J value) {
        if (value == null) {
            return null;
        }
        return (J)((NestedTable)this.returnedClass().cast(value.copy()));
    }

    public J replace(J detached, J managed, Object owner) {
        return this.deepCopy(detached);
    }

    public boolean equals(J x, J y) {
        if (x != null && !((NestedTable)NestedTable.class.cast(x)).isNull_booleanValue()) {
            return x.equals(y);
        }
        if (y != null && !((NestedTable)NestedTable.class.cast(y)).isNull_booleanValue()) {
            return y.equals(x);
        }
        if (x != null && y != null) {
            return x.getClass().equals(y.getClass());
        }
        return true;
    }

    public int hashCode(J x) {
        return x.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    public J nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return this.nullSafeGet(rs, position, owner);
    }

    public void nullSafeSet(PreparedStatement st, J value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.nullSafeSet(st, value, index);
    }

    public J nullSafeGet(ResultSet rs, int position, Object owner) throws HibernateException, SQLException {
        for (NestedTableService service : services) {
            if (!service.test((Object)rs)) continue;
            NestedTable<?, ?> result = null;
            Object[] array = service.nullSafeGet(rs, position, owner);
            if (array != null) {
                result = this.newNestedTable();
                result.fill(array);
            }
            return (J)((NestedTable)this.returnedClass().cast(result));
        }
        throw new ServiceConfigurationError("No one service found");
    }

    public void nullSafeSet(PreparedStatement st, J value, int index) throws HibernateException, SQLException {
        NestedTable table = (NestedTable)NestedTable.class.cast(value);
        for (NestedTableService service : services) {
            if (!service.test((Object)st)) continue;
            String typeName = this.newNestedTable().getSQLTypeName();
            service.nullSafeSet(st, table, index, typeName);
            return;
        }
        throw new ServiceConfigurationError("No one service found");
    }

    public int getSqlType() {
        return 2003;
    }

    static {
        ServiceLoader.load(NestedTableService.class).forEach(services::add);
    }
}

