/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.build.war;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="build-version-info", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class BeforeBuildWar
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    private String outputDirectoryRoot;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    private static final String PLATFORM_2MCA_VERSION = "platform2mca-version";
    private static final String VERSION_FILENAME = "version.info";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"========== build-version-info =========");
        this.getLog().info((CharSequence)("outputDirectoryRoot : " + this.outputDirectoryRoot));
        File versionFile = new File(this.outputDirectoryRoot);
        versionFile.mkdirs();
        versionFile = new File(versionFile, VERSION_FILENAME);
        String versionAbsolutePath = versionFile.getAbsolutePath();
        PrintWriter writer = null;
        String appVersion = null;
        String buildNumber = null;
        String platform2mcaVersion = this.getPlatform2MCAVersion();
        if (!platform2mcaVersion.isEmpty()) {
            try {
                appVersion = platform2mcaVersion.substring(0, platform2mcaVersion.lastIndexOf("."));
                buildNumber = platform2mcaVersion.substring(platform2mcaVersion.lastIndexOf(".") + 1);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Getting platform2mca-version failed. Skip create version.info.");
                this.getLog().error((Throwable)e);
                return;
            }
            try {
                File file = new File(versionAbsolutePath);
                writer = new PrintWriter(new FileOutputStream(file));
                Date dt = new Date();
                writer.println("app.version=" + appVersion);
                writer.println("app.buildNumber=" + buildNumber);
                writer.println("app.buildTimestamp=" + dt);
                writer.println("app.buildUser=" + System.getProperty("user.name"));
                writer.close();
            }
            catch (FileNotFoundException e) {
                this.getLog().error((CharSequence)"Failed version.info file creation.");
                this.getLog().error((Throwable)e);
            }
        }
    }

    private String getPlatform2MCAVersion() {
        Properties properties = this.project.getProperties();
        Object platform2mcaVersion = properties.get(PLATFORM_2MCA_VERSION);
        if (platform2mcaVersion instanceof String) {
            return (String)platform2mcaVersion;
        }
        return "";
    }
}

