/*
 * Decompiled with CFR 0.152.
 */
package ru.cft.platform.vfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class VFSAssistant {
    private static final String JAR_FILE_EXTENSION = ".jar";

    public static ArrayList<String> getPhysicalAbsolutPath(Object other) throws IOException {
        if (!(other instanceof VirtualFile)) {
            throw new RuntimeException(other.toString() + "not a virtual file");
        }
        VirtualFile vf = (VirtualFile)other;
        vf = vf.getParent().getParent();
        SuffixMatchFilter classVisitor = new SuffixMatchFilter(Arrays.asList(JAR_FILE_EXTENSION), VisitorAttributes.RECURSE);
        List vfList = vf.getChildren((VirtualFileFilter)classVisitor);
        ArrayList<String> vfPath = new ArrayList<String>();
        for (VirtualFile virtualFile : vfList) {
            File f = virtualFile.getPhysicalFile();
            if (f.isDirectory()) {
                File[] jars;
                for (File jar : jars = f.getParentFile().listFiles((dir, name) -> name.toLowerCase().endsWith(JAR_FILE_EXTENSION))) {
                    vfPath.add(jar.getAbsolutePath());
                }
                continue;
            }
            vfPath.add(f.getAbsolutePath());
        }
        return vfPath;
    }

    public static URI getPhysicalPath(Object other) {
        try {
            return VFSUtils.getPhysicalURI((VirtualFile)((VirtualFile)other).getParent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URI getPhysicalPathDir(Object other, String namespaceCorrect) {
        try {
            VirtualFile parentVFSFile = ((VirtualFile)other).getParent();
            while (!parentVFSFile.asFileURI().toString().endsWith(namespaceCorrect)) {
                parentVFSFile = parentVFSFile.getParent();
            }
            VFSAssistant.bypassingChildren(parentVFSFile);
            return VFSUtils.getPhysicalURI((VirtualFile)parentVFSFile);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void bypassingChildren(VirtualFile vf) {
        if (vf != null && vf.isDirectory()) {
            try {
                List childrenFiles = vf.getChildrenRecursively();
                for (VirtualFile virtualFile : childrenFiles) {
                    virtualFile.getPhysicalFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

